/*
 * Decompiled with CFR 0.152.
 */
package com.ni.rio;

import com.ni.rio.NiRioConstants;
import com.ni.rio.NiRioStatus;
import com.sun.cldc.jna.Function;
import com.sun.cldc.jna.NativeLibrary;
import com.sun.cldc.jna.Pointer;
import com.sun.cldc.jna.ptr.IntByReference;

public class NiRioSrv
implements NiRioConstants {
    private static final Function openFn = NativeLibrary.getDefaultInstance().getFunction("NiRioSrv_device_open");
    private static final Function closeFn = NativeLibrary.getDefaultInstance().getFunction("NiRioSrv_device_close");
    private static final Function set32Fn = NativeLibrary.getDefaultInstance().getFunction("NiRioSrv_device_set32");
    private static final Function setStringFn = NativeLibrary.getDefaultInstance().getFunction("NiRioSrv_device_setString");
    private static final Function configSetFn = NativeLibrary.getDefaultInstance().getFunction("NiRioSrv_device_configSet");
    private static final Function configAddFifoInputExFn = NativeLibrary.getDefaultInstance().getFunction("NiRioSrv_device_configAddFifoInputEx");
    private static final Function configAddFifoOutputExFn = NativeLibrary.getDefaultInstance().getFunction("NiRioSrv_device_configAddFifoOutputEx");
    private static final Function fifoConfigFn = NativeLibrary.getDefaultInstance().getFunction("NiRioSrv_device_fifoConfig");
    private static final Function fifoStartFn = NativeLibrary.getDefaultInstance().getFunction("NiRioSrv_device_fifoStart");
    private static final Function fifoStopFn = NativeLibrary.getDefaultInstance().getFunction("NiRioSrv_device_fifoStop");
    private static final Function fifoReadFn = NativeLibrary.getDefaultInstance().getFunction("NiRioSrv_device_fifoRead");
    private static final Function fifoStopAllFn = NativeLibrary.getDefaultInstance().getFunction("NiRioSrv_device_fifoStopAll");
    private static final Function poke32Fn = NativeLibrary.getDefaultInstance().getFunction("NiRioSrv_device_poke32");
    private static final Function poke16Fn = NativeLibrary.getDefaultInstance().getFunction("NiRioSrv_device_poke16");
    private static final Function peek32Fn = NativeLibrary.getDefaultInstance().getFunction("NiRioSrv_device_peek32");
    private static final Function irqReserveFn = NativeLibrary.getDefaultInstance().getFunction("NiRioSrv_device_irqReserve");
    private static final Function irqUnreserveFn = NativeLibrary.getDefaultInstance().getFunction("NiRioSrv_device_irqUnreserve");
    private static final Function irqWaitFn = NativeLibrary.getDefaultInstance().getFunction("NiRioSrv_device_irqWait");

    public static int open(String resource, NiRioStatus status) {
        Pointer resourcePtr = Pointer.createStringBuffer((String)resource);
        int deviceHandle = openFn.call2(resourcePtr, status.getPointer());
        resourcePtr.free();
        status.assertNonfatal();
        if (deviceHandle == 0) {
            status.setStatus(-63195);
        }
        return deviceHandle;
    }

    public static void close(int hClient, NiRioStatus status) {
        closeFn.call2(hClient, status.getPointer());
        status.assertNonfatal();
    }

    public static void set32(int hClient, int attribute, int value, NiRioStatus status) {
        set32Fn.call4(hClient, attribute, value, status.getPointer());
        status.assertNonfatal();
    }

    public static void setString(int hClient, int attribute, String value, NiRioStatus status) {
        Pointer valuePtr = Pointer.createStringBuffer((String)value);
        setStringFn.call4(hClient, attribute, valuePtr, status.getPointer());
        valuePtr.free();
        status.assertNonfatal();
    }

    public static void configSet(int hClient, int attribute, NiRioStatus status) {
        configSetFn.call3(hClient, attribute, status.getPointer());
        status.assertNonfatal();
    }

    public static void configAddFifoInputEx(int hClient, int channel, int baseAddress, int depthInSamples, int version, NiRioStatus status) {
        configAddFifoInputExFn.call6(hClient, channel, baseAddress, depthInSamples, version, status.getPointer());
        status.assertNonfatal();
    }

    public static void configAddFifoOutputEx(int hClient, int channel, int baseAddress, int depthInSamples, int version, NiRioStatus status) {
        configAddFifoOutputExFn.call6(hClient, channel, baseAddress, depthInSamples, version, status.getPointer());
        status.assertNonfatal();
    }

    public static void fifoConfig(int hClient, int channel, int fifoDepthInElements, NiRioStatus status) {
        fifoConfigFn.call4(hClient, channel, fifoDepthInElements, status.getPointer());
        status.assertNonfatal();
    }

    public static void fifoStart(int hClient, int channel, NiRioStatus status) {
        fifoStartFn.call3(hClient, channel, status.getPointer());
        status.assertNonfatal();
    }

    public static void fifoStop(int hClient, int channel, NiRioStatus status) {
        fifoStopFn.call3(hClient, channel, status.getPointer());
        status.assertNonfatal();
    }

    public static void fifoRead(int hClient, int channel, Pointer buf, int num, int timeout, IntByReference read, IntByReference remaining, NiRioStatus status) {
        fifoReadFn.call8(hClient, channel, buf.address().toUWord().toPrimitive(), num, timeout, read.getPointer().address().toUWord().toPrimitive(), remaining.getPointer().address().toUWord().toPrimitive(), status.getPointer());
        status.assertNonfatal();
    }

    public static void fifoStopAll(int hClient, NiRioStatus status) {
        fifoStopAllFn.call2(hClient, status.getPointer());
        status.assertNonfatal();
    }

    public static void poke32(int hClient, int offset, int value, NiRioStatus status) {
        poke32Fn.call4(hClient, offset, value, status.getPointer());
        status.assertNonfatal();
    }

    public static void poke16(int hClient, int offset, short value, NiRioStatus status) {
        poke16Fn.call4(hClient, offset, (int)value, status.getPointer());
        status.assertNonfatal();
    }

    public static int peek32(int hClient, int offset, NiRioStatus status) {
        int value = peek32Fn.call3(hClient, offset, status.getPointer());
        status.assertNonfatal();
        return value;
    }

    public static void irqReserve(int hClient, IntByReference context, NiRioStatus status) {
        irqReserveFn.call3(hClient, context.getPointer().address().toUWord().toPrimitive(), status.getPointer());
        status.assertNonfatal();
    }

    public static void irqUnreserve(int hClient, IntByReference context, NiRioStatus status) {
        irqUnreserveFn.call3(hClient, context.getPointer().address().toUWord().toPrimitive(), status.getPointer());
        status.assertNonfatal();
    }

    public static int irqWait(int hClient, IntByReference context, int irqs, int timeout, NiRioStatus status) {
        int value = irqWaitFn.call5(hClient, context.getPointer().address().toUWord().toPrimitive(), irqs, timeout, status.getPointer());
        status.assertNonfatal();
        return value;
    }
}

