/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Resource;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.fpga.tInterrupt;
import edu.wpi.first.wpilibj.fpga.tInterruptManager;

public abstract class InterruptableSensorBase
extends SensorBase {
    protected tInterrupt m_interrupt = null;
    protected tInterruptManager m_manager = null;
    protected int m_interruptIndex;
    protected static Resource interrupts = new Resource(8);

    public void allocateInterrupts(boolean watcher) {
        if (!watcher) {
            throw new IllegalArgumentException("Interrupt callbacks not yet supported");
        }
        this.m_interrupt = new tInterrupt((byte)this.m_interruptIndex);
        this.m_interrupt.writeConfig_WaitForAck(false);
        this.m_manager = new tInterruptManager(1 << this.m_interruptIndex, watcher);
    }

    public void cancelInterrupts() {
        if (this.m_interrupt == null || this.m_manager == null) {
            throw new IllegalStateException();
        }
        this.m_interrupt.Release();
        this.m_interrupt = null;
        this.m_manager.Release();
        this.m_manager = null;
    }

    public void waitForInterrupt(double timeout) {
        this.m_manager.watch((int)(timeout * 1000.0));
    }

    public void enableInterrupts() {
        throw new IllegalArgumentException("Interrupt callbacks not yet supported");
    }

    public void disableInterrupts() {
        throw new IllegalArgumentException("Interrupt callbacks not yet supported");
    }

    public double readInterruptTimestamp() {
        return (double)this.m_interrupt.readTimeStamp() * 1.0E-6;
    }
}

