/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.can;

import com.sun.cldc.jna.BlockingFunction;
import com.sun.cldc.jna.Function;
import com.sun.cldc.jna.NativeLibrary;
import com.sun.cldc.jna.Pointer;
import com.sun.cldc.jna.TaskExecutor;
import com.sun.cldc.jna.ptr.IntByReference;
import edu.wpi.first.wpilibj.can.CANExceptionFactory;
import edu.wpi.first.wpilibj.can.CANTimeoutException;
import edu.wpi.first.wpilibj.communication.Semaphore;

public class JaguarCANDriver {
    public static final int kMaxMessageDataSize = 8;
    private static final TaskExecutor taskExecutor = new TaskExecutor("FRC CANJaguar Task executor");
    private static final Function sendMessageFn = NativeLibrary.getDefaultInstance().getFunction("FRC_NetworkCommunication_JaguarCANDriver_sendMessage");
    private static final BlockingFunction receiveMessageFn = NativeLibrary.getDefaultInstance().getBlockingFunction("FRC_NetworkCommunication_JaguarCANDriver_receiveMessage");
    public int receivedMessageId;
    private static final Function receiveMessageStart_semFn;
    private static final Function receiveMessageCompleteFn;

    public static void sendMessage(int messageID, byte[] data, int dataSize) throws CANTimeoutException {
        Pointer sendDataBufferPointer = new Pointer(8);
        sendDataBufferPointer.setBytes(0L, data, 0, dataSize);
        IntByReference sendStatus = new IntByReference(0);
        sendStatus.setValue(0);
        sendMessageFn.call4(messageID, sendDataBufferPointer, dataSize, sendStatus.getPointer().address().toUWord().toPrimitive());
        int statusValue = sendStatus.getValue();
        sendStatus.free();
        sendDataBufferPointer.free();
        CANExceptionFactory.checkStatus(statusValue, messageID);
    }

    public byte receiveMessage(int messageID, byte[] data, double timeout) throws CANTimeoutException {
        int dataSize = 0;
        IntByReference recvStatus = new IntByReference(0);
        recvStatus.setValue(0);
        Pointer messageIdPtr = new Pointer(4);
        messageIdPtr.setInt(0L, messageID);
        Pointer dataSizePtr = new Pointer(1);
        dataSizePtr.setByte(0L, (byte)0);
        Pointer recvDataBufferPointer = new Pointer(8);
        receiveMessageFn.call5(messageIdPtr, recvDataBufferPointer, dataSizePtr, (int)(timeout * 1000.0), recvStatus.getPointer().address().toUWord().toPrimitive());
        int statusValue = recvStatus.getValue();
        if (statusValue >= 0) {
            dataSize = dataSizePtr.getByte(0L);
            this.receivedMessageId = messageIdPtr.getInt(0L);
            recvDataBufferPointer.getBytes(0L, data, 0, data.length < dataSize ? data.length : dataSize);
        }
        recvDataBufferPointer.free();
        dataSizePtr.free();
        messageIdPtr.free();
        recvStatus.free();
        CANExceptionFactory.checkStatus(statusValue, messageID);
        return (byte)dataSize;
    }

    public byte receiveMessage(int messageID, byte[] data) throws CANTimeoutException {
        return this.receiveMessage(messageID, data, 0.01);
    }

    public boolean receiveMessageStart(int messageID, Semaphore sem, double timeout) throws CANTimeoutException {
        int retVal = 0;
        IntByReference recvStatus = new IntByReference(0);
        recvStatus.setValue(0);
        retVal = receiveMessageStart_semFn.call4(messageID, sem.getPointer(), (int)(timeout * 1000.0), recvStatus.getPointer().address().toUWord().toPrimitive());
        int statusValue = recvStatus.getValue();
        recvStatus.free();
        CANExceptionFactory.checkStatus(statusValue, messageID);
        return retVal != 0;
    }

    public byte receiveMessageComplete(int messageID, byte[] data) throws CANTimeoutException {
        int dataSize = 0;
        IntByReference recvStatus = new IntByReference(0);
        recvStatus.setValue(0);
        Pointer messageIdPtr = new Pointer(4);
        messageIdPtr.setInt(0L, messageID);
        Pointer dataSizePtr = new Pointer(1);
        dataSizePtr.setByte(0L, (byte)0);
        Pointer recvDataBufferPointer = new Pointer(8);
        receiveMessageCompleteFn.call4(messageIdPtr, recvDataBufferPointer, dataSizePtr, recvStatus.getPointer().address().toUWord().toPrimitive());
        int statusValue = recvStatus.getValue();
        if (statusValue >= 0) {
            dataSize = dataSizePtr.getByte(0L);
            this.receivedMessageId = messageIdPtr.getInt(0L);
            recvDataBufferPointer.getBytes(0L, data, 0, data.length < dataSize ? data.length : dataSize);
        }
        recvDataBufferPointer.free();
        dataSizePtr.free();
        messageIdPtr.free();
        recvStatus.free();
        CANExceptionFactory.checkStatus(statusValue, messageID);
        return (byte)dataSize;
    }

    static {
        receiveMessageFn.setTaskExecutor(taskExecutor);
        receiveMessageStart_semFn = NativeLibrary.getDefaultInstance().getFunction("FRC_NetworkCommunication_JaguarCANDriver_receiveMessageStart_sem");
        receiveMessageCompleteFn = NativeLibrary.getDefaultInstance().getFunction("FRC_NetworkCommunication_JaguarCANDriver_receiveMessageComplete");
    }
}

