/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.fpga;

import com.ni.rio.NiRioSrv;
import edu.wpi.first.wpilibj.fpga.tSystem;

public class tAccumulator
extends tSystem {
    public static final int kNumSystems = 2;
    public final int m_SystemIndex;
    private static final int kOutput_Value_BitfieldMask = 0;
    private static final int kOutput_Value_BitfieldOffset = 32;
    private static final int kOutput_Count_BitfieldMask = -1;
    private static final int kOutput_Count_BitfieldOffset = 0;
    private static final int kAccumulator0_Output_Address = 33764;
    private static final int kAccumulator1_Output_Address = 33748;
    private static final int[] kOutput_Addresses = new int[]{33764, 33748};
    private static final int kAccumulator0_Center_Address = 33772;
    private static final int kAccumulator1_Center_Address = 33756;
    private static final int[] kCenter_Addresses = new int[]{33772, 33756};
    private static final int kAccumulator0_Reset_Address = 33768;
    private static final int kAccumulator1_Reset_Address = 33752;
    private static final int[] kReset_Addresses = new int[]{33768, 33752};
    private static final int kAccumulator0_Deadband_Address = 33760;
    private static final int kAccumulator1_Deadband_Address = 33744;
    private static final int[] kDeadband_Addresses = new int[]{33760, 33744};

    public tAccumulator(int sys_index) {
        this.m_SystemIndex = sys_index;
        if (status.isNotFatal() && this.m_SystemIndex >= 2) {
            status.setStatus(-50003);
        }
    }

    protected void finalize() {
        super.finalize();
    }

    public int getSystemIndex() {
        return this.m_SystemIndex;
    }

    public tOutput readOutput() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kOutput_Addresses[this.m_SystemIndex], status);
        int regValue2 = NiRioSrv.peek32(m_DeviceHandle, kOutput_Addresses[this.m_SystemIndex], status);
        int regValue3 = NiRioSrv.peek32(m_DeviceHandle, kOutput_Addresses[this.m_SystemIndex], status);
        return new tOutput(regValue, regValue2, regValue3);
    }

    public long readOutput_Value() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kOutput_Addresses[this.m_SystemIndex], status);
        int regValue2 = NiRioSrv.peek32(m_DeviceHandle, kOutput_Addresses[this.m_SystemIndex], status);
        int regValue3 = NiRioSrv.peek32(m_DeviceHandle, kOutput_Addresses[this.m_SystemIndex], status);
        tOutput val = new tOutput(regValue, regValue2, regValue3);
        return val.Value;
    }

    public long readOutput_Count() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kOutput_Addresses[this.m_SystemIndex], status);
        int regValue2 = NiRioSrv.peek32(m_DeviceHandle, kOutput_Addresses[this.m_SystemIndex], status);
        int regValue3 = NiRioSrv.peek32(m_DeviceHandle, kOutput_Addresses[this.m_SystemIndex], status);
        tOutput val = new tOutput(regValue, regValue2, regValue3);
        return val.Count;
    }

    public void writeCenter(int value) {
        NiRioSrv.poke32(m_DeviceHandle, kCenter_Addresses[this.m_SystemIndex], value, status);
    }

    public int readCenter() {
        return NiRioSrv.peek32(m_DeviceHandle, kCenter_Addresses[this.m_SystemIndex], status);
    }

    public void strobeReset() {
        NiRioSrv.poke32(m_DeviceHandle, kReset_Addresses[this.m_SystemIndex], 1, status);
    }

    public void writeDeadband(int value) {
        NiRioSrv.poke32(m_DeviceHandle, kDeadband_Addresses[this.m_SystemIndex], value, status);
    }

    public int readDeadband() {
        return NiRioSrv.peek32(m_DeviceHandle, kDeadband_Addresses[this.m_SystemIndex], status);
    }

    public static class tOutput {
        public final long Value;
        public final int Count;

        public tOutput(int regValue1, int regValue2, int regValue3) {
            this.Value = (long)regValue1 << 32 | (long)regValue2;
            this.Count = regValue3;
        }
    }
}

