/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.fpga;

import com.ni.rio.NiRioSrv;
import edu.wpi.first.wpilibj.fpga.tSystem;

public class tCounter
extends tSystem {
    public static final int kNumSystems = 8;
    public final int m_SystemIndex;
    private static final int kOutput_Direction_BitfieldMask = Integer.MIN_VALUE;
    private static final int kOutput_Direction_BitfieldOffset = 31;
    private static final int kOutput_Value_BitfieldMask = Integer.MAX_VALUE;
    private static final int kOutput_Value_BitfieldOffset = 0;
    private static final int kCounter0_Output_Address = 33408;
    private static final int kCounter1_Output_Address = 33388;
    private static final int kCounter2_Output_Address = 33368;
    private static final int kCounter3_Output_Address = 33348;
    private static final int kCounter4_Output_Address = 33328;
    private static final int kCounter5_Output_Address = 33308;
    private static final int kCounter6_Output_Address = 33288;
    private static final int kCounter7_Output_Address = 33268;
    private static final int[] kOutput_Addresses = new int[]{33408, 33388, 33368, 33348, 33328, 33308, 33288, 33268};
    private static final int kConfig_UpSource_Channel_BitfieldMask = -268435456;
    private static final int kConfig_UpSource_Channel_BitfieldOffset = 28;
    private static final int kConfig_UpSource_Module_BitfieldMask = 0x8000000;
    private static final int kConfig_UpSource_Module_BitfieldOffset = 27;
    private static final int kConfig_UpSource_AnalogTrigger_BitfieldMask = 0x4000000;
    private static final int kConfig_UpSource_AnalogTrigger_BitfieldOffset = 26;
    private static final int kConfig_DownSource_Channel_BitfieldMask = 0x3C00000;
    private static final int kConfig_DownSource_Channel_BitfieldOffset = 22;
    private static final int kConfig_DownSource_Module_BitfieldMask = 0x200000;
    private static final int kConfig_DownSource_Module_BitfieldOffset = 21;
    private static final int kConfig_DownSource_AnalogTrigger_BitfieldMask = 0x100000;
    private static final int kConfig_DownSource_AnalogTrigger_BitfieldOffset = 20;
    private static final int kConfig_IndexSource_Channel_BitfieldMask = 983040;
    private static final int kConfig_IndexSource_Channel_BitfieldOffset = 16;
    private static final int kConfig_IndexSource_Module_BitfieldMask = 32768;
    private static final int kConfig_IndexSource_Module_BitfieldOffset = 15;
    private static final int kConfig_IndexSource_AnalogTrigger_BitfieldMask = 16384;
    private static final int kConfig_IndexSource_AnalogTrigger_BitfieldOffset = 14;
    private static final int kConfig_IndexActiveHigh_BitfieldMask = 8192;
    private static final int kConfig_IndexActiveHigh_BitfieldOffset = 13;
    private static final int kConfig_UpRisingEdge_BitfieldMask = 4096;
    private static final int kConfig_UpRisingEdge_BitfieldOffset = 12;
    private static final int kConfig_UpFallingEdge_BitfieldMask = 2048;
    private static final int kConfig_UpFallingEdge_BitfieldOffset = 11;
    private static final int kConfig_DownRisingEdge_BitfieldMask = 1024;
    private static final int kConfig_DownRisingEdge_BitfieldOffset = 10;
    private static final int kConfig_DownFallingEdge_BitfieldMask = 512;
    private static final int kConfig_DownFallingEdge_BitfieldOffset = 9;
    private static final int kConfig_Mode_BitfieldMask = 384;
    private static final int kConfig_Mode_BitfieldOffset = 7;
    private static final int kConfig_PulseLengthThreshold_BitfieldMask = 126;
    private static final int kConfig_PulseLengthThreshold_BitfieldOffset = 1;
    private static final int kConfig_PulseLengthThreshold_FixedPointIntegerShift = 8;
    private static final int kConfig_Enable_BitfieldMask = 1;
    private static final int kConfig_Enable_BitfieldOffset = 0;
    private static final int kCounter0_Config_Address = 33416;
    private static final int kCounter1_Config_Address = 33396;
    private static final int kCounter2_Config_Address = 33376;
    private static final int kCounter3_Config_Address = 33356;
    private static final int kCounter4_Config_Address = 33336;
    private static final int kCounter5_Config_Address = 33316;
    private static final int kCounter6_Config_Address = 33296;
    private static final int kCounter7_Config_Address = 33276;
    private static final int[] kConfig_Addresses = new int[]{33416, 33396, 33376, 33356, 33336, 33316, 33296, 33276};
    private static final int kCounter0_Reset_Address = 33412;
    private static final int kCounter1_Reset_Address = 33392;
    private static final int kCounter2_Reset_Address = 33372;
    private static final int kCounter3_Reset_Address = 33352;
    private static final int kCounter4_Reset_Address = 33332;
    private static final int kCounter5_Reset_Address = 33312;
    private static final int kCounter6_Reset_Address = 33292;
    private static final int kCounter7_Reset_Address = 33272;
    private static final int[] kReset_Addresses = new int[]{33412, 33392, 33372, 33352, 33332, 33312, 33292, 33272};
    private static final int kTimerOutput_Period_BitfieldMask = -512;
    private static final int kTimerOutput_Period_BitfieldOffset = 9;
    private static final int kTimerOutput_Period_FixedPointIntegerShift = 1;
    private static final int kTimerOutput_Count_BitfieldMask = 510;
    private static final int kTimerOutput_Count_BitfieldOffset = 1;
    private static final int kTimerOutput_Stalled_BitfieldMask = 1;
    private static final int kTimerOutput_Stalled_BitfieldOffset = 0;
    private static final int kCounter0_TimerOutput_Address = 33400;
    private static final int kCounter1_TimerOutput_Address = 33380;
    private static final int kCounter2_TimerOutput_Address = 33360;
    private static final int kCounter3_TimerOutput_Address = 33340;
    private static final int kCounter4_TimerOutput_Address = 33320;
    private static final int kCounter5_TimerOutput_Address = 33300;
    private static final int kCounter6_TimerOutput_Address = 33280;
    private static final int kCounter7_TimerOutput_Address = 33260;
    private static final int[] kTimerOutput_Addresses = new int[]{33400, 33380, 33360, 33340, 33320, 33300, 33280, 33260};
    private static final int kTimerConfig_StallPeriod_BitfieldMask = -256;
    private static final int kTimerConfig_StallPeriod_BitfieldOffset = 8;
    private static final int kTimerConfig_StallPeriod_FixedPointIntegerShift = 1;
    private static final int kTimerConfig_AverageSize_BitfieldMask = 254;
    private static final int kTimerConfig_AverageSize_BitfieldOffset = 1;
    private static final int kTimerConfig_UpdateWhenEmpty_BitfieldMask = 1;
    private static final int kTimerConfig_UpdateWhenEmpty_BitfieldOffset = 0;
    private static final int kCounter0_TimerConfig_Address = 33404;
    private static final int kCounter1_TimerConfig_Address = 33384;
    private static final int kCounter2_TimerConfig_Address = 33364;
    private static final int kCounter3_TimerConfig_Address = 33344;
    private static final int kCounter4_TimerConfig_Address = 33324;
    private static final int kCounter5_TimerConfig_Address = 33304;
    private static final int kCounter6_TimerConfig_Address = 33284;
    private static final int kCounter7_TimerConfig_Address = 33264;
    private static final int[] kTimerConfig_Addresses = new int[]{33404, 33384, 33364, 33344, 33324, 33304, 33284, 33264};

    public tCounter(int sys_index) {
        this.m_SystemIndex = sys_index;
        if (status.isNotFatal() && this.m_SystemIndex >= 8) {
            status.setStatus(-50003);
        }
    }

    protected void finalize() {
        super.finalize();
    }

    public int getSystemIndex() {
        return this.m_SystemIndex;
    }

    public int readOutput() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kOutput_Addresses[this.m_SystemIndex], status);
        return regValue;
    }

    public boolean readOutput_Direction() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kOutput_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & Integer.MIN_VALUE) >>> 31;
        return bitfieldValue != 0;
    }

    public int readOutput_Value() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kOutput_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & Integer.MAX_VALUE) >>> 0;
        bitfieldValue <<= 1;
        return bitfieldValue >>= 1;
    }

    public void writeConfig(int value) {
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], value, status);
    }

    public void writeConfig_UpSource_Channel(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFFF;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value << 28 & 0xF0000000, status);
    }

    public void writeConfig_UpSource_Module(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xF7FFFFFF;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value << 27 & 0x8000000, status);
    }

    public void writeConfig_UpSource_AnalogTrigger(boolean value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFBFFFFFF;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 26 & 0x4000000, status);
    }

    public void writeConfig_DownSource_Channel(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFC3FFFFF;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value << 22 & 0x3C00000, status);
    }

    public void writeConfig_DownSource_Module(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFDFFFFF;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value << 21 & 0x200000, status);
    }

    public void writeConfig_DownSource_AnalogTrigger(boolean value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFEFFFFF;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 20 & 0x100000, status);
    }

    public void writeConfig_IndexSource_Channel(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFF0FFFF;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value << 16 & 0xF0000, status);
    }

    public void writeConfig_IndexSource_Module(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFF7FFF;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value << 15 & 0x8000, status);
    }

    public void writeConfig_IndexSource_AnalogTrigger(boolean value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFBFFF;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 14 & 0x4000, status);
    }

    public void writeConfig_IndexActiveHigh(boolean value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFDFFF;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 13 & 0x2000, status);
    }

    public void writeConfig_UpRisingEdge(boolean value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFEFFF;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 12 & 0x1000, status);
    }

    public void writeConfig_UpFallingEdge(boolean value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFF7FF;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 11 & 0x800, status);
    }

    public void writeConfig_DownRisingEdge(boolean value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFBFF;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 10 & 0x400, status);
    }

    public void writeConfig_DownFallingEdge(boolean value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFDFF;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 9 & 0x200, status);
    }

    public void writeConfig_Mode(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFE7F;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value << 7 & 0x180, status);
    }

    public void writeConfig_PulseLengthThreshold(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFF81;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value >>> 8 << 1 & 0x7E, status);
    }

    public void writeConfig_Enable(boolean value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFFFE;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 0 & 1, status);
    }

    public int readConfig() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        return regValue;
    }

    public byte readConfig_UpSource_Channel() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xF0000000) >>> 28;
        return (byte)(bitfieldValue & 0xF);
    }

    public byte readConfig_UpSource_Module() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x8000000) >>> 27;
        return (byte)(bitfieldValue & 1);
    }

    public boolean readConfig_UpSource_AnalogTrigger() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x4000000) >>> 26;
        return bitfieldValue != 0;
    }

    public byte readConfig_DownSource_Channel() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x3C00000) >>> 22;
        return (byte)(bitfieldValue & 0xF);
    }

    public byte readConfig_DownSource_Module() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x200000) >>> 21;
        return (byte)(bitfieldValue & 1);
    }

    public boolean readConfig_DownSource_AnalogTrigger() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x100000) >>> 20;
        return bitfieldValue != 0;
    }

    public byte readConfig_IndexSource_Channel() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xF0000) >>> 16;
        return (byte)(bitfieldValue & 0xF);
    }

    public byte readConfig_IndexSource_Module() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x8000) >>> 15;
        return (byte)(bitfieldValue & 1);
    }

    public boolean readConfig_IndexSource_AnalogTrigger() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x4000) >>> 14;
        return bitfieldValue != 0;
    }

    public boolean readConfig_IndexActiveHigh() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x2000) >>> 13;
        return bitfieldValue != 0;
    }

    public boolean readConfig_UpRisingEdge() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x1000) >>> 12;
        return bitfieldValue != 0;
    }

    public boolean readConfig_UpFallingEdge() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x800) >>> 11;
        return bitfieldValue != 0;
    }

    public boolean readConfig_DownRisingEdge() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x400) >>> 10;
        return bitfieldValue != 0;
    }

    public boolean readConfig_DownFallingEdge() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x200) >>> 9;
        return bitfieldValue != 0;
    }

    public byte readConfig_Mode() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x180) >>> 7;
        return (byte)(bitfieldValue & 3);
    }

    public short readConfig_PulseLengthThreshold() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x7E) >>> 1 << 8;
        return (short)(bitfieldValue & 0x3FFF);
    }

    public boolean readConfig_Enable() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 1) >>> 0;
        return bitfieldValue != 0;
    }

    public void strobeReset() {
        NiRioSrv.poke32(m_DeviceHandle, kReset_Addresses[this.m_SystemIndex], 1, status);
    }

    public int readTimerOutput() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kTimerOutput_Addresses[this.m_SystemIndex], status);
        return regValue;
    }

    public int readTimerOutput_Period() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kTimerOutput_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xFFFFFE00) >>> 9 << 1;
        return bitfieldValue & 0xFFFFFF;
    }

    public byte readTimerOutput_Count() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kTimerOutput_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x1FE) >>> 1;
        bitfieldValue <<= 24;
        return (byte)(bitfieldValue >>= 24);
    }

    public boolean readTimerOutput_Stalled() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kTimerOutput_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 1) >>> 0;
        return bitfieldValue != 0;
    }

    public void writeTimerConfig(int value) {
        NiRioSrv.poke32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], value, status);
    }

    public void writeTimerConfig_StallPeriod(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFF;
        NiRioSrv.poke32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], regValue |= value >>> 1 << 8 & 0xFFFFFF00, status);
    }

    public void writeTimerConfig_AverageSize(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFF01;
        NiRioSrv.poke32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], regValue |= value << 1 & 0xFE, status);
    }

    public void writeTimerConfig_UpdateWhenEmpty(boolean value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFFFE;
        NiRioSrv.poke32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 0 & 1, status);
    }

    public int readTimerConfig() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], status);
        return regValue;
    }

    public int readTimerConfig_StallPeriod() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xFFFFFF00) >>> 8 << 1;
        return bitfieldValue & 0x1FFFFFF;
    }

    public byte readTimerConfig_AverageSize() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xFE) >>> 1;
        return (byte)(bitfieldValue & 0x7F);
    }

    public boolean readTimerConfig_UpdateWhenEmpty() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kTimerConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 1) >>> 0;
        return bitfieldValue != 0;
    }
}

