/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.fpga;

import com.ni.rio.NiRioSrv;
import edu.wpi.first.wpilibj.fpga.tSystem;

public class tWatchdog
extends tSystem {
    public static final int kNumSystems = 1;
    private static final int kStatus_SystemActive_BitfieldMask = Integer.MIN_VALUE;
    private static final int kStatus_SystemActive_BitfieldOffset = 31;
    private static final int kStatus_Alive_BitfieldMask = 0x40000000;
    private static final int kStatus_Alive_BitfieldOffset = 30;
    private static final int kStatus_SysDisableCount_BitfieldMask = 1073709056;
    private static final int kStatus_SysDisableCount_BitfieldOffset = 15;
    private static final int kStatus_DisableCount_BitfieldMask = Short.MAX_VALUE;
    private static final int kStatus_DisableCount_BitfieldOffset = 0;
    private static final int kWatchdog_Status_Address = 33864;
    private static final int kWatchdog_Feed_Address = 33860;
    private static final int kWatchdog_Kill_Address = 33856;
    private static final int kWatchdog_Immortal_Address = 33844;
    private static final int kWatchdog_Expiration_Address = 33848;
    private static final int kWatchdog_Timer_Address = 33852;

    protected void finalize() {
        super.finalize();
    }

    public static int readStatus() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, 33864, status);
        return regValue;
    }

    public static boolean readStatus_SystemActive() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, 33864, status);
        int bitfieldValue = (regValue & Integer.MIN_VALUE) >>> 31;
        return bitfieldValue != 0;
    }

    public static boolean readStatus_Alive() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, 33864, status);
        int bitfieldValue = (regValue & 0x40000000) >>> 30;
        return bitfieldValue != 0;
    }

    public static short readStatus_SysDisableCount() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, 33864, status);
        int bitfieldValue = (regValue & 0x3FFF8000) >>> 15;
        return (short)(bitfieldValue & Short.MAX_VALUE);
    }

    public static short readStatus_DisableCount() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, 33864, status);
        int bitfieldValue = (regValue & Short.MAX_VALUE) >>> 0;
        return (short)(bitfieldValue & Short.MAX_VALUE);
    }

    public static void strobeFeed() {
        NiRioSrv.poke32(m_DeviceHandle, 33860, 1, status);
    }

    public static void strobeKill() {
        NiRioSrv.poke32(m_DeviceHandle, 33856, 1, status);
    }

    public static void writeImmortal(boolean value) {
        NiRioSrv.poke32(m_DeviceHandle, 33844, value ? 1 : 0, status);
    }

    public static boolean readImmortal() {
        return NiRioSrv.peek32(m_DeviceHandle, 33844, status) != 0;
    }

    public static void writeExpiration(long value) {
        NiRioSrv.poke32(m_DeviceHandle, 33848, (int)value, status);
    }

    public static long readExpiration() {
        return (long)NiRioSrv.peek32(m_DeviceHandle, 33848, status) & 0xFFFFFFFFL;
    }

    public static long readTimer() {
        return (long)NiRioSrv.peek32(m_DeviceHandle, 33852, status) & 0xFFFFFFFFL;
    }
}

