/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.image;

import edu.wpi.first.wpilibj.image.BinaryImage;
import edu.wpi.first.wpilibj.image.Image;
import edu.wpi.first.wpilibj.image.MonoImage;
import edu.wpi.first.wpilibj.image.NIVision;
import edu.wpi.first.wpilibj.image.NIVisionException;

public abstract class ColorImage
extends Image {
    ColorImage(NIVision.ImageType type) throws NIVisionException {
        super(type);
    }

    ColorImage(ColorImage sourceImage) {
        super(sourceImage);
    }

    private BinaryImage threshold(NIVision.ColorMode colorMode, int low1, int high1, int low2, int high2, int low3, int high3) throws NIVisionException {
        BinaryImage res = new BinaryImage();
        NIVision.Range range1 = new NIVision.Range(low1, high1);
        NIVision.Range range2 = new NIVision.Range(low2, high2);
        NIVision.Range range3 = new NIVision.Range(low3, high3);
        try {
            NIVision.colorThreshold(res.image, this.image, colorMode, range1.getPointer(), range2.getPointer(), range3.getPointer());
        }
        catch (NIVisionException e) {
            res.free();
            throw e;
        }
        finally {
            range1.free();
            range2.free();
            range3.free();
        }
        return res;
    }

    public BinaryImage thresholdRGB(int redLow, int redHigh, int greenLow, int greenHigh, int blueLow, int blueHigh) throws NIVisionException {
        return this.threshold(NIVision.ColorMode.IMAQ_RGB, redLow, redHigh, greenLow, greenHigh, blueLow, blueHigh);
    }

    public BinaryImage thresholdHSL(int hueLow, int hueHigh, int saturationLow, int saturationHigh, int luminenceLow, int luminenceHigh) throws NIVisionException {
        return this.threshold(NIVision.ColorMode.IMAQ_HSL, hueLow, hueHigh, saturationLow, saturationHigh, luminenceLow, luminenceHigh);
    }

    public BinaryImage thresholdHSV(int hueLow, int hueHigh, int saturationLow, int saturationHigh, int valueLow, int valueHigh) throws NIVisionException {
        return this.threshold(NIVision.ColorMode.IMAQ_HSV, hueLow, hueHigh, saturationLow, saturationHigh, valueLow, valueHigh);
    }

    public BinaryImage thresholdHSI(int hueLow, int hueHigh, int saturationLow, int saturationHigh, int intansityLow, int intensityHigh) throws NIVisionException {
        return this.threshold(NIVision.ColorMode.IMAQ_HSI, hueLow, hueHigh, saturationLow, saturationHigh, intansityLow, intensityHigh);
    }

    MonoImage extractFirstColorPlane(NIVision.ColorMode mode) throws NIVisionException {
        MonoImage result = new MonoImage();
        try {
            NIVision.extractColorPlanes(this.image, mode, result.image, null, null);
        }
        catch (NIVisionException e) {
            result.free();
            throw e;
        }
        return result;
    }

    MonoImage extractSecondColorPlane(NIVision.ColorMode mode) throws NIVisionException {
        MonoImage result = new MonoImage();
        try {
            NIVision.extractColorPlanes(this.image, mode, null, result.image, null);
        }
        catch (NIVisionException e) {
            result.free();
            throw e;
        }
        return result;
    }

    MonoImage extractThirdColorPlane(NIVision.ColorMode mode) throws NIVisionException {
        MonoImage result = new MonoImage();
        try {
            NIVision.extractColorPlanes(this.image, mode, null, null, result.image);
        }
        catch (NIVisionException e) {
            result.free();
            throw e;
        }
        return result;
    }

    public MonoImage getRedPlane() throws NIVisionException {
        return this.extractFirstColorPlane(NIVision.ColorMode.IMAQ_RGB);
    }

    public MonoImage getGreenPlane() throws NIVisionException {
        return this.extractSecondColorPlane(NIVision.ColorMode.IMAQ_RGB);
    }

    public MonoImage getBluePlane() throws NIVisionException {
        return this.extractThirdColorPlane(NIVision.ColorMode.IMAQ_RGB);
    }

    public MonoImage getHSLHuePlane() throws NIVisionException {
        return this.extractFirstColorPlane(NIVision.ColorMode.IMAQ_HSL);
    }

    public MonoImage getHSVHuePlane() throws NIVisionException {
        return this.extractFirstColorPlane(NIVision.ColorMode.IMAQ_HSV);
    }

    public MonoImage getHSIHuePlane() throws NIVisionException {
        return this.extractFirstColorPlane(NIVision.ColorMode.IMAQ_HSI);
    }

    public MonoImage getHSLSaturationPlane() throws NIVisionException {
        return this.extractSecondColorPlane(NIVision.ColorMode.IMAQ_HSL);
    }

    public MonoImage getHSVSaturationPlane() throws NIVisionException {
        return this.extractSecondColorPlane(NIVision.ColorMode.IMAQ_HSV);
    }

    public MonoImage getHSISaturationPlane() throws NIVisionException {
        return this.extractSecondColorPlane(NIVision.ColorMode.IMAQ_HSI);
    }

    public MonoImage getLuminancePlane() throws NIVisionException {
        return this.extractThirdColorPlane(NIVision.ColorMode.IMAQ_HSL);
    }

    public MonoImage getValuePlane() throws NIVisionException {
        return this.extractThirdColorPlane(NIVision.ColorMode.IMAQ_HSV);
    }

    public MonoImage getIntensityPlane() throws NIVisionException {
        return this.extractThirdColorPlane(NIVision.ColorMode.IMAQ_HSI);
    }

    ColorImage replaceFirstColorPlane(NIVision.ColorMode mode, MonoImage plane) throws NIVisionException {
        NIVision.replaceColorPlanes(this.image, this.image, mode, plane.image, null, null);
        return this;
    }

    ColorImage replaceSecondColorPlane(NIVision.ColorMode mode, MonoImage plane) throws NIVisionException {
        NIVision.replaceColorPlanes(this.image, this.image, mode, null, plane.image, null);
        return this;
    }

    ColorImage replaceThirdColorPlane(NIVision.ColorMode mode, MonoImage plane) throws NIVisionException {
        NIVision.replaceColorPlanes(this.image, this.image, mode, null, null, plane.image);
        return this;
    }

    public ColorImage replaceRedPlane(MonoImage plane) throws NIVisionException {
        return this.replaceFirstColorPlane(NIVision.ColorMode.IMAQ_RGB, plane);
    }

    public ColorImage replaceGreenPlane(MonoImage plane) throws NIVisionException {
        return this.replaceSecondColorPlane(NIVision.ColorMode.IMAQ_RGB, plane);
    }

    public ColorImage replaceBluePlane(MonoImage plane) throws NIVisionException {
        return this.replaceThirdColorPlane(NIVision.ColorMode.IMAQ_RGB, plane);
    }

    public ColorImage replaceHSLHuePlane(MonoImage plane) throws NIVisionException {
        return this.replaceFirstColorPlane(NIVision.ColorMode.IMAQ_HSL, plane);
    }

    public ColorImage replaceHSVHuePlane(MonoImage plane) throws NIVisionException {
        return this.replaceFirstColorPlane(NIVision.ColorMode.IMAQ_HSV, plane);
    }

    public ColorImage replaceHSIHuePlane(MonoImage plane) throws NIVisionException {
        return this.replaceFirstColorPlane(NIVision.ColorMode.IMAQ_HSI, plane);
    }

    public ColorImage replaceHSLSaturationPlane(MonoImage plane) throws NIVisionException {
        return this.replaceSecondColorPlane(NIVision.ColorMode.IMAQ_HSL, plane);
    }

    public ColorImage replaceHSVSaturationPlane(MonoImage plane) throws NIVisionException {
        return this.replaceSecondColorPlane(NIVision.ColorMode.IMAQ_HSV, plane);
    }

    public ColorImage replaceHSISaturationPlane(MonoImage plane) throws NIVisionException {
        return this.replaceSecondColorPlane(NIVision.ColorMode.IMAQ_HSI, plane);
    }

    public ColorImage replaceLuminancePlane(MonoImage plane) throws NIVisionException {
        return this.replaceThirdColorPlane(NIVision.ColorMode.IMAQ_HSL, plane);
    }

    public ColorImage replaceValuePlane(MonoImage plane) throws NIVisionException {
        return this.replaceThirdColorPlane(NIVision.ColorMode.IMAQ_HSV, plane);
    }

    public ColorImage replaceIntensityPlane(MonoImage plane) throws NIVisionException {
        return this.replaceThirdColorPlane(NIVision.ColorMode.IMAQ_HSI, plane);
    }

    public ColorImage colorEqualize() throws NIVisionException {
        NIVision.colorEqualize(this.image, this.image, true);
        return this;
    }

    public ColorImage luminanceEqualize() throws NIVisionException {
        NIVision.colorEqualize(this.image, this.image, false);
        return this;
    }
}

