/*
 * Decompiled with CFR 0.152.
 */
package com.team1987.breakaway;

import com.team1987.breakaway.TrackerDashboard;
import edu.wpi.first.wpilibj.AnalogChannel;
import edu.wpi.first.wpilibj.Compressor;
import edu.wpi.first.wpilibj.DigitalInput;
import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.DriverStationEnhancedIO;
import edu.wpi.first.wpilibj.DriverStationLCD;
import edu.wpi.first.wpilibj.Encoder;
import edu.wpi.first.wpilibj.IterativeRobot;
import edu.wpi.first.wpilibj.Joystick;
import edu.wpi.first.wpilibj.Relay;
import edu.wpi.first.wpilibj.RobotDrive;
import edu.wpi.first.wpilibj.Solenoid;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.Victor;
import edu.wpi.first.wpilibj.Watchdog;

public class BreakawayRobot
extends IterativeRobot {
    AnalogChannel m_kickerWinderRevSensor;
    DigitalInput m_kickerSolenoidExtended;
    DigitalInput m_kickerSolenoidReturned;
    DigitalInput m_LanceLowered;
    DigitalInput m_LanceExtended;
    DigitalInput m_kickerWinderEmergencyStop;
    DigitalInput m_ballDetector;
    RobotDrive m_robotDrive;
    DriverStation m_DS;
    DriverStationEnhancedIO m_DSEIO;
    DriverStationLCD m_DSLCD;
    Encoder m_leftDriveEncoder;
    Encoder m_rightDriveEncoder;
    Encoder m_kickerEncoder;
    Joystick m_rightStick;
    Joystick m_leftStick;
    Compressor m_compressor;
    Relay m_LanceExtenderRelay;
    Relay m_combineRelay;
    Solenoid m_LanceRaiseSolenoidIn;
    Solenoid m_LanceRaiseSolenoidOut;
    Solenoid m_kickerSolenoidIn;
    Solenoid m_kickerSolenoidOut;
    Timer m_LanceExtenderTimer;
    Timer m_kickerTriggerTimer;
    Timer m_kickerLockTimer;
    Timer m_autoKickSequenceTimer;
    Timer m_autoDetectorDelayTimer;
    Timer m_kickerLockDelayTimer;
    Victor m_kickerWinder;
    Victor m_winch;
    TrackerDashboard trackerDashboard;
    boolean activateLance;
    boolean autoClearBump;
    boolean autoDetectorDelayLock;
    boolean autoDriveBackward;
    boolean autoKick;
    boolean autoSpeedLock;
    boolean firstBallLock;
    int kickerSwitchReading = 0;
    boolean joystickKickerStrength8 = true;
    boolean joystickKickerStrength7 = false;
    boolean joystickKickerStrength6 = false;
    boolean joystickKickerStrength5 = false;
    boolean joystickKickerStrength4 = false;
    boolean joystickKickerStrength3 = false;
    boolean joystickKickerStrength2 = false;
    boolean joystickKickerStrength1 = false;
    boolean kickerDelayLock;
    boolean kickerLowTrajectory;
    boolean kickerLowTrajectoryOldButtonValue;
    boolean kickerTriggerTimerResetLock;
    boolean LanceActivated;
    boolean LanceExtendTimerLock;
    double kickerWinderVoltageLimit;
    double kScoreThreshold;
    double autoLeftSpeed;
    double autoRightSpeed;
    int autoBallCount;
    int autoBallKicks;
    int autoKickSequence;
    int autoZone;
    int consecutiveBallLock;
    int kickerEncoderCountLimit;
    int kickerState;
    int kickerStrength;
    int oldKickerStrength;
    int printedKickerState;
    String strKickerState;

    public BreakawayRobot() {
        System.out.println("Instantiating Breakaway robot");
        Watchdog.getInstance().setExpiration(1.0);
        Watchdog.getInstance().feed();
        this.m_DS = DriverStation.getInstance();
        this.m_DSEIO = this.m_DS.getEnhancedIO();
        this.m_DSLCD = DriverStationLCD.getInstance();
        this.m_robotDrive = new RobotDrive(1, 2, 3, 4);
        this.m_rightStick = new Joystick(2);
        this.m_leftStick = new Joystick(1);
        this.m_compressor = new Compressor(11, 3);
        this.m_LanceRaiseSolenoidIn = new Solenoid(4);
        this.m_LanceRaiseSolenoidOut = new Solenoid(3);
        this.m_kickerSolenoidIn = new Solenoid(1);
        this.m_kickerSolenoidOut = new Solenoid(2);
        this.m_kickerWinder = new Victor(5);
        this.m_winch = new Victor(6);
        this.m_LanceExtenderRelay = new Relay(1, Relay.Direction.kBoth);
        this.m_combineRelay = new Relay(2, Relay.Direction.kBoth);
        this.m_kickerSolenoidExtended = new DigitalInput(9);
        this.m_kickerSolenoidReturned = new DigitalInput(10);
        this.m_LanceLowered = new DigitalInput(12);
        this.m_LanceExtended = new DigitalInput(8);
        this.m_kickerWinderEmergencyStop = new DigitalInput(13);
        this.m_ballDetector = new DigitalInput(7);
        this.m_leftDriveEncoder = new Encoder(1, 2);
        this.m_rightDriveEncoder = new Encoder(3, 4);
        this.m_kickerEncoder = new Encoder(5, 6);
        this.m_LanceExtenderTimer = new Timer();
        this.m_kickerTriggerTimer = new Timer();
        this.m_kickerLockTimer = new Timer();
        this.m_autoKickSequenceTimer = new Timer();
        this.m_autoDetectorDelayTimer = new Timer();
        this.m_kickerLockDelayTimer = new Timer();
        this.trackerDashboard = new TrackerDashboard();
        this.m_kickerWinderRevSensor = new AnalogChannel(7);
        this.autoDetectorDelayLock = true;
        this.autoKick = false;
        this.autoSpeedLock = false;
        this.consecutiveBallLock = 0;
        this.firstBallLock = false;
        this.kickerDelayLock = false;
        this.kickerTriggerTimerResetLock = false;
        this.kScoreThreshold = 0.01;
        this.LanceActivated = false;
        this.LanceExtendTimerLock = false;
        this.autoLeftSpeed = -0.5;
        this.autoRightSpeed = -0.5;
        this.activateLance = false;
        this.autoClearBump = false;
        this.autoDriveBackward = false;
    }

    public void robotInit() {
        Watchdog.getInstance().setExpiration(1.0);
        Watchdog.getInstance().feed();
        this.m_compressor.start();
        this.m_kickerWinder.set(0.0);
        this.m_LanceExtenderRelay.set(Relay.Value.kOff);
        this.m_leftDriveEncoder.start();
        this.m_rightDriveEncoder.start();
        this.m_kickerEncoder.start();
        if (!this.m_LanceExtended.get()) {
            this.m_LanceRaiseSolenoidIn.set(true);
            this.m_LanceRaiseSolenoidOut.set(false);
        }
        this.autoKickSequence = 0;
        for (int i = 1; i < 10; ++i) {
            try {
                this.m_DSEIO.setDigitalConfig(i, DriverStationEnhancedIO.tDigitalConfig.kInputPullUp);
                continue;
            }
            catch (DriverStationEnhancedIO.EnhancedIOException ex) {
                ex.printStackTrace();
            }
        }
        this.m_LanceExtenderTimer.start();
        this.m_kickerTriggerTimer.start();
        this.m_kickerLockTimer.start();
        this.m_autoDetectorDelayTimer.start();
        this.m_kickerLockDelayTimer.start();
    }

    public void disabledInit() {
        Watchdog.getInstance().feed();
    }

    public void autonomousInit() {
        System.out.println("Feeding Watchdog - autonomousInit");
        Watchdog.getInstance().feed();
        this.kickerStrength = 8;
        this.kickerWinderVoltageLimit = 4.96;
        this.autoZone = 3;
        this.autoBallKicks = 3;
        this.kickerState = 2;
        this.autoKickSequence = 0;
        this.m_leftDriveEncoder.reset();
        this.m_rightDriveEncoder.reset();
        this.m_autoKickSequenceTimer.reset();
        System.out.println("In autonomous init");
    }

    public void teleopInit() {
        System.out.println("Feeding Watchdog - teleopInit");
        Watchdog.getInstance().feed();
        this.setKickerStrength();
        this.setWinderVoltage();
        this.autoKick = false;
        this.kickerState = 2;
        this.m_combineRelay.set(Relay.Value.kReverse);
        this.m_rightDriveEncoder.reset();
        this.m_leftDriveEncoder.reset();
    }

    public void disabledPeriodic() {
        this.kickerQuickFix();
        Watchdog.getInstance().feed();
        this.setKickerStrength();
        this.setWinderVoltage();
        this.printMessages();
    }

    public void autonomousPeriodic() {
        Watchdog.getInstance().feed();
        this.printMessages();
        this.driveStraight();
        if ((double)this.m_leftDriveEncoder.get() > 3500.0 || (double)this.m_rightDriveEncoder.get() > 3500.0) {
            this.m_robotDrive.tankDrive(0.0, 0.0);
        } else if (this.autoBallKicks > 0) {
            switch (this.autoKickSequence) {
                case 0: {
                    this.m_combineRelay.set(Relay.Value.kReverse);
                    this.m_robotDrive.tankDrive(-0.5, -0.5);
                    ++this.autoKickSequence;
                    this.m_autoKickSequenceTimer.start();
                    break;
                }
                case 1: {
                    if (!this.m_ballDetector.get() || !(this.m_autoDetectorDelayTimer.get() > 2.5)) break;
                    this.m_autoKickSequenceTimer.reset();
                    ++this.autoKickSequence;
                    break;
                }
                case 2: {
                    if (!(this.m_autoKickSequenceTimer.get() > 0.5)) break;
                    this.m_robotDrive.tankDrive(0.0, 0.0);
                    ++this.autoKickSequence;
                    break;
                }
                case 3: {
                    if (!(this.m_autoKickSequenceTimer.get() > 2.0)) break;
                    this.m_autoDetectorDelayTimer.reset();
                    this.autoKick = true;
                    ++this.autoKickSequence;
                    break;
                }
                case 4: {
                    if (!(this.m_autoKickSequenceTimer.get() > 2.0)) break;
                    this.m_robotDrive.tankDrive(-0.5, -0.5);
                    this.autoKickSequence = 1;
                }
            }
        } else if ((double)this.m_leftDriveEncoder.get() > 875.0 || (double)this.m_rightDriveEncoder.get() > 875.0) {
            this.autoDriveBackward = true;
            this.m_robotDrive.tankDrive(0.5, 0.5);
        } else {
            this.m_robotDrive.tankDrive(0.0, 0.0);
        }
        System.out.println("case=" + this.autoKickSequence + "ball sensor" + this.m_ballDetector.get());
    }

    public void teleopPeriodic() {
        Watchdog.getInstance().feed();
        this.m_robotDrive.arcadeDrive(this.m_rightStick, false);
        this.setKickerStrength();
        if (this.kickerSwitchReading == 0) {
            this.kickerQuickFix();
        } else {
            this.setWinderVoltage();
        }
        this.combine();
        this.Lance();
        this.winchControl();
        this.printMessages();
    }

    public void disabledContinuous() {
    }

    public void autonomousContinuous() {
        this.kicker();
    }

    public void teleopContinuous() {
        this.kicker();
    }

    public void combine() {
        if (this.m_rightStick.getRawButton(3)) {
            this.m_combineRelay.set(Relay.Value.kReverse);
        } else if (this.m_rightStick.getRawButton(4) || this.m_rightStick.getRawButton(5)) {
            this.m_combineRelay.set(Relay.Value.kOff);
        } else if (this.m_rightStick.getRawButton(2)) {
            this.m_combineRelay.set(Relay.Value.kForward);
        }
    }

    public void Lance() {
        if (this.m_leftStick.getRawButton(2)) {
            if (!this.m_LanceExtended.get()) {
                this.m_LanceRaiseSolenoidIn.set(true);
                this.m_LanceRaiseSolenoidOut.set(false);
                this.m_LanceExtenderRelay.set(Relay.Value.kOff);
            } else {
                this.m_LanceExtenderRelay.set(Relay.Value.kForward);
            }
        } else if (this.m_leftStick.getRawButton(3)) {
            if (this.m_LanceLowered.get()) {
                this.m_LanceRaiseSolenoidIn.set(false);
                this.m_LanceRaiseSolenoidOut.set(true);
                this.LanceActivated = true;
            } else {
                this.m_LanceExtenderRelay.set(Relay.Value.kReverse);
            }
        } else {
            this.m_LanceExtenderRelay.set(Relay.Value.kOff);
        }
    }

    public void kicker() {
        switch (this.kickerState) {
            case 0: {
                this.strKickerState = "Kicker Ready";
                if (!(this.m_kickerTriggerTimer.get() >= 2.0) || !this.m_rightStick.getRawButton(1) && !this.autoKick) break;
                this.kickerState = 1;
                break;
            }
            case 1: {
                this.strKickerState = "Kicker Kicking";
                this.m_kickerSolenoidIn.set(false);
                this.m_kickerSolenoidOut.set(true);
                if (this.m_kickerSolenoidReturned.get()) break;
                this.kickerState = 2;
                --this.autoBallKicks;
                break;
            }
            case 2: {
                this.strKickerState = "Returning";
                if (!this.m_kickerSolenoidExtended.get()) {
                    this.kickerState = 5;
                    break;
                }
                if (this.m_kickerWinderRevSensor.getVoltage() >= 4.25 || this.m_kickerWinderRevSensor.getVoltage() <= 0.25) {
                    this.m_kickerWinder.set(0.07);
                    if (!(Math.abs(0.25 - this.m_kickerWinderRevSensor.getVoltage()) <= 0.1)) break;
                    this.m_kickerWinder.set(0.0);
                    this.m_kickerLockDelayTimer.reset();
                    this.kickerState = 3;
                    break;
                }
                this.m_kickerWinder.set(0.2);
                break;
            }
            case 3: {
                if (!(this.m_kickerLockDelayTimer.get() > 0.9)) break;
                this.m_kickerLockTimer.reset();
                this.kickerState = 4;
                break;
            }
            case 4: {
                this.strKickerState = "Kicker Locking";
                this.m_kickerSolenoidIn.set(true);
                this.m_kickerSolenoidOut.set(false);
                if (this.m_kickerSolenoidExtended.get() && !(this.m_kickerLockTimer.get() >= 1.5)) break;
                this.kickerState = 5;
                break;
            }
            case 5: {
                this.strKickerState = "Kicker Locked";
                this.m_kickerWinder.set(0.75);
                this.kickerState = 6;
                break;
            }
            case 6: {
                this.strKickerState = "Kicker Winding";
                this.autoKick = false;
                if (!(this.m_kickerWinderRevSensor.getVoltage() >= this.kickerWinderVoltageLimit)) break;
                this.m_kickerWinder.set(0.0);
                this.m_kickerTriggerTimer.reset();
                this.kickerState = 0;
            }
        }
        if (!this.m_kickerWinderEmergencyStop.get()) {
            this.m_kickerWinder.set(0.0);
            this.autoKick = false;
            if (this.kickerState != 0 && this.kickerState != 1) {
                this.m_kickerTriggerTimer.reset();
                this.kickerState = 0;
            }
        }
    }

    public void printMessages() {
        if (this.m_rightStick.getZ() < 0.0) {
            this.m_DSLCD.println(DriverStationLCD.Line.kMain6, 1, "KTrigTimer=" + this.m_kickerTriggerTimer.get() + "          ");
            this.m_DSLCD.println(DriverStationLCD.Line.kUser2, 1, "Lance Extended=" + this.m_LanceExtended.get() + "          ");
            this.m_DSLCD.println(DriverStationLCD.Line.kUser3, 1, "Lance Lowered=" + this.m_LanceLowered.get() + "          ");
            this.m_DSLCD.println(DriverStationLCD.Line.kUser4, 1, "LDE=" + this.m_leftDriveEncoder.get() + "                    ");
            this.m_DSLCD.println(DriverStationLCD.Line.kUser5, 1, "RDE=" + this.m_rightDriveEncoder.get() + "                    ");
        } else if (this.m_leftStick.getZ() < 0.0) {
            this.m_DSLCD.println(DriverStationLCD.Line.kMain6, 1, "aKick Delay Timer=" + this.m_autoKickSequenceTimer.get() + "          ");
            this.m_DSLCD.println(DriverStationLCD.Line.kUser2, 1, "K Trigger Delay Timer=" + this.m_kickerTriggerTimer.get() + "          ");
            this.m_DSLCD.println(DriverStationLCD.Line.kUser3, 1, "K%=" + this.m_kickerWinderRevSensor.getVoltage() / 5.0 * 100.0 + "% Volt=" + this.m_kickerWinderRevSensor.getVoltage() + "          ");
            this.m_DSLCD.println(DriverStationLCD.Line.kUser4, 1, "LDE=" + this.m_leftDriveEncoder.get() + "                    ");
            this.m_DSLCD.println(DriverStationLCD.Line.kUser5, 1, "RDE=" + this.m_rightDriveEncoder.get() + "                    ");
            this.m_DSLCD.println(DriverStationLCD.Line.kUser6, 1, "KVoltage=" + this.m_kickerWinderRevSensor.getVoltage() + "          ");
        } else {
            this.m_DSLCD.println(DriverStationLCD.Line.kMain6, 1, "Ball Detected = " + this.m_ballDetector.get() + "          ");
            this.m_DSLCD.println(DriverStationLCD.Line.kUser2, 1, this.strKickerState + "                    ");
            this.m_DSLCD.println(DriverStationLCD.Line.kUser3, 1, "K Strength = " + this.kickerStrength + "          ");
            if (this.m_kickerTriggerTimer.get() >= 2.0) {
                this.m_DSLCD.println(DriverStationLCD.Line.kUser4, 1, "Kicker Delay Complete          ");
            } else {
                this.m_DSLCD.println(DriverStationLCD.Line.kUser4, 1, "Kicker Delayed          ");
            }
            this.m_DSLCD.println(DriverStationLCD.Line.kUser5, 1, "K%=" + this.m_kickerWinderRevSensor.getVoltage() / 5.0 * 100.0 + "%          ");
            this.m_DSLCD.println(DriverStationLCD.Line.kUser6, 1, "Lance Used=" + this.LanceActivated + "          ");
        }
        this.m_DSLCD.updateLCD();
    }

    public void setKickerStrength() {
        try {
            this.kickerSwitchReading = ~this.m_DSEIO.getDigitals() & 0xFF;
        }
        catch (DriverStationEnhancedIO.EnhancedIOException ex) {
            ex.printStackTrace();
        }
        this.autoZone = this.kickerStrength < 3 ? 1 : (this.kickerStrength > 2 && this.kickerStrength < 6 ? 2 : 3);
        this.autoBallKicks = this.autoZone;
    }

    public void setWinderVoltage() {
        switch (this.kickerSwitchReading) {
            case 1: {
                this.kickerWinderVoltageLimit = 3.0;
                break;
            }
            case 2: {
                this.kickerWinderVoltageLimit = 4.0;
                break;
            }
            case 4: {
                this.kickerStrength = 3;
                this.kickerWinderVoltageLimit = 4.5;
                break;
            }
            case 8: {
                this.kickerStrength = 4;
                this.kickerWinderVoltageLimit = 4.7;
                break;
            }
            case 16: {
                this.kickerStrength = 5;
                this.kickerWinderVoltageLimit = 4.8;
                break;
            }
            case 32: {
                this.kickerStrength = 6;
                this.kickerWinderVoltageLimit = 4.85;
                break;
            }
            case 64: {
                this.kickerStrength = 7;
                this.kickerWinderVoltageLimit = 4.85;
                break;
            }
            case 128: {
                this.kickerStrength = 8;
                this.kickerWinderVoltageLimit = 4.96;
            }
        }
    }

    public void winchControl() {
        if (this.m_leftStick.getRawButton(4) || this.m_leftStick.getRawButton(5)) {
            this.m_winch.set(1.0);
        } else if (this.m_leftStick.getRawButton(1) && this.LanceActivated) {
            this.m_winch.set(-1.0);
        } else {
            this.m_winch.set(0.0);
        }
    }

    void driveStraight() {
        if (this.autoDriveBackward) {
            if ((double)this.m_leftDriveEncoder.get() > 50.0) {
                this.autoLeftSpeed = (double)this.m_leftDriveEncoder.get() + 50.0 < (double)this.m_rightDriveEncoder.get() ? -0.45 : -0.5;
            }
            if ((double)this.m_rightDriveEncoder.get() > 50.0) {
                this.autoRightSpeed = (double)this.m_rightDriveEncoder.get() + 50.0 < (double)this.m_leftDriveEncoder.get() ? -0.45 : -0.5;
            }
        } else {
            if ((double)this.m_leftDriveEncoder.get() > 50.0) {
                this.autoLeftSpeed = (double)this.m_leftDriveEncoder.get() - 50.0 > (double)this.m_rightDriveEncoder.get() ? -0.45 : -0.5;
            }
            if ((double)this.m_rightDriveEncoder.get() > 50.0) {
                this.autoRightSpeed = (double)this.m_rightDriveEncoder.get() - 50.0 > (double)this.m_leftDriveEncoder.get() ? -0.45 : -0.5;
            }
        }
    }

    void kickerQuickFix() {
        if (this.m_rightStick.getRawButton(6)) {
            this.joystickKickerStrength1 = true;
            this.joystickKickerStrength2 = false;
            this.joystickKickerStrength3 = false;
            this.joystickKickerStrength4 = false;
            this.joystickKickerStrength5 = false;
            this.joystickKickerStrength6 = false;
            this.joystickKickerStrength7 = false;
            this.joystickKickerStrength8 = false;
        }
        if (this.m_rightStick.getRawButton(7)) {
            this.joystickKickerStrength1 = false;
            this.joystickKickerStrength2 = true;
            this.joystickKickerStrength3 = false;
            this.joystickKickerStrength4 = false;
            this.joystickKickerStrength5 = false;
            this.joystickKickerStrength6 = false;
            this.joystickKickerStrength7 = false;
            this.joystickKickerStrength8 = false;
        }
        if (this.m_rightStick.getRawButton(8)) {
            this.joystickKickerStrength1 = false;
            this.joystickKickerStrength2 = false;
            this.joystickKickerStrength3 = false;
            this.joystickKickerStrength4 = true;
            this.joystickKickerStrength5 = false;
            this.joystickKickerStrength6 = false;
            this.joystickKickerStrength7 = false;
            this.joystickKickerStrength8 = false;
        }
        if (this.m_rightStick.getRawButton(9)) {
            this.joystickKickerStrength1 = false;
            this.joystickKickerStrength2 = false;
            this.joystickKickerStrength3 = false;
            this.joystickKickerStrength4 = false;
            this.joystickKickerStrength5 = true;
            this.joystickKickerStrength6 = false;
            this.joystickKickerStrength7 = false;
            this.joystickKickerStrength8 = false;
        }
        if (this.m_rightStick.getRawButton(10)) {
            this.joystickKickerStrength1 = false;
            this.joystickKickerStrength2 = false;
            this.joystickKickerStrength3 = false;
            this.joystickKickerStrength4 = false;
            this.joystickKickerStrength5 = false;
            this.joystickKickerStrength6 = true;
            this.joystickKickerStrength7 = false;
            this.joystickKickerStrength8 = false;
        }
        if (this.m_rightStick.getRawButton(11)) {
            this.joystickKickerStrength1 = false;
            this.joystickKickerStrength2 = false;
            this.joystickKickerStrength3 = false;
            this.joystickKickerStrength4 = false;
            this.joystickKickerStrength5 = false;
            this.joystickKickerStrength6 = false;
            this.joystickKickerStrength7 = false;
            this.joystickKickerStrength8 = true;
        }
        if (this.joystickKickerStrength8) {
            this.kickerStrength = 8;
            this.kickerWinderVoltageLimit = 4.96;
        } else if (this.joystickKickerStrength7) {
            this.kickerStrength = 7;
            this.kickerWinderVoltageLimit = 4.9;
        } else if (this.joystickKickerStrength6) {
            this.kickerStrength = 6;
            this.kickerWinderVoltageLimit = 4.85;
        } else if (this.joystickKickerStrength5) {
            this.kickerStrength = 5;
            this.kickerWinderVoltageLimit = 4.8;
        } else if (this.joystickKickerStrength4) {
            this.kickerStrength = 4;
            this.kickerWinderVoltageLimit = 4.7;
        } else if (this.joystickKickerStrength3) {
            this.kickerStrength = 3;
            this.kickerWinderVoltageLimit = 4.5;
        } else if (this.joystickKickerStrength2) {
            this.kickerStrength = 2;
            this.kickerWinderVoltageLimit = 4.0;
        } else if (this.joystickKickerStrength1) {
            this.kickerStrength = 1;
            this.kickerWinderVoltageLimit = 3.0;
        }
    }
}

