/*
 * Decompiled with CFR 0.152.
 */
package com.team1987.breakaway;

import com.team1987.breakaway.Target;
import edu.wpi.first.wpilibj.AnalogModule;
import edu.wpi.first.wpilibj.Dashboard;
import edu.wpi.first.wpilibj.DigitalModule;
import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.Solenoid;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class TrackerDashboard {
    Date time = new Date();

    public TrackerDashboard() {
        Timer dashTimer = new Timer();
        dashTimer.schedule(new TimerTask(){

            public void run() {
                TrackerDashboard.this.updateDefaultDashboard();
            }
        }, 0L, 100L);
    }

    void updateDefaultDashboard() {
        int i;
        int i2;
        Dashboard lowDashData = DriverStation.getInstance().getDashboardPackerLow();
        lowDashData.addCluster();
        lowDashData.addCluster();
        lowDashData.addCluster();
        for (i2 = 1; i2 <= 8; ++i2) {
            lowDashData.addFloat((float)AnalogModule.getInstance(1).getAverageVoltage(i2));
        }
        lowDashData.finalizeCluster();
        lowDashData.addCluster();
        for (i2 = 1; i2 <= 8; ++i2) {
            lowDashData.addFloat((float)AnalogModule.getInstance(2).getAverageVoltage(i2));
        }
        lowDashData.finalizeCluster();
        lowDashData.finalizeCluster();
        lowDashData.addCluster();
        lowDashData.addCluster();
        lowDashData.addCluster();
        int module = 4;
        lowDashData.addByte(DigitalModule.getInstance(module).getRelayForward());
        lowDashData.addByte(DigitalModule.getInstance(module).getRelayForward());
        lowDashData.addShort(DigitalModule.getInstance(module).getAllDIO());
        lowDashData.addShort(DigitalModule.getInstance(module).getDIODirection());
        lowDashData.addCluster();
        for (i = 1; i <= 10; ++i) {
            lowDashData.addByte((byte)DigitalModule.getInstance(module).getPWM(i));
        }
        lowDashData.finalizeCluster();
        lowDashData.finalizeCluster();
        lowDashData.finalizeCluster();
        lowDashData.addCluster();
        lowDashData.addCluster();
        module = 6;
        lowDashData.addByte(DigitalModule.getInstance(module).getRelayForward());
        lowDashData.addByte(DigitalModule.getInstance(module).getRelayReverse());
        lowDashData.addShort(DigitalModule.getInstance(module).getAllDIO());
        lowDashData.addShort(DigitalModule.getInstance(module).getDIODirection());
        lowDashData.addCluster();
        for (i = 1; i <= 10; ++i) {
            lowDashData.addByte((byte)DigitalModule.getInstance(module).getPWM(i));
        }
        lowDashData.finalizeCluster();
        lowDashData.finalizeCluster();
        lowDashData.finalizeCluster();
        lowDashData.finalizeCluster();
        lowDashData.addByte(Solenoid.getAll());
        lowDashData.finalizeCluster();
        lowDashData.commit();
    }

    public void updateVisionDashboard(double joyStickX, double gyroAngle, double gyroRate, double targetX, Target[] targets) {
        Dashboard highDashData = DriverStation.getInstance().getDashboardPackerHigh();
        highDashData.addCluster();
        highDashData.addCluster();
        highDashData.addDouble(joyStickX);
        highDashData.addDouble((gyroAngle + 360.0 + 180.0) % 360.0 - 180.0);
        highDashData.addDouble(gyroRate);
        highDashData.addDouble(targetX);
        highDashData.finalizeCluster();
        highDashData.addCluster();
        highDashData.addArray();
        for (int i = 0; i < targets.length; ++i) {
            highDashData.addCluster();
            highDashData.addDouble(targets[i].m_score);
            highDashData.addCluster();
            highDashData.addCluster();
            highDashData.addFloat((float)(targets[i].m_xPos / targets[i].m_xMax));
            highDashData.addFloat((float)targets[i].m_yPos);
            highDashData.finalizeCluster();
            highDashData.addDouble(targets[i].m_rotation);
            highDashData.addDouble(targets[i].m_majorRadius);
            highDashData.addDouble(targets[i].m_minorRadius);
            highDashData.addDouble(targets[i].m_rawScore);
            highDashData.finalizeCluster();
            highDashData.finalizeCluster();
        }
        highDashData.finalizeArray();
        highDashData.addInt((int)this.time.getTime());
        highDashData.finalizeCluster();
        highDashData.finalizeCluster();
        highDashData.commit();
    }
}

