/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DigitalModule;
import edu.wpi.first.wpilibj.DigitalSource;
import edu.wpi.first.wpilibj.util.AllocationException;
import edu.wpi.first.wpilibj.util.CheckedAllocationException;

public class DigitalInput
extends DigitalSource {
    private int m_channel;
    private DigitalModule m_module;
    private boolean m_lastValue;

    private void initDigitalInput(int slot, int channel) {
        DigitalInput.checkDigitalChannel(channel);
        DigitalInput.checkDigitalModule(slot);
        this.m_channel = channel;
        this.m_module = DigitalModule.getInstance(slot);
        this.m_module.allocateDIO(channel, true);
    }

    public DigitalInput(int channel) {
        this.initDigitalInput(DigitalInput.getDefaultDigitalModule(), channel);
    }

    public DigitalInput(int slot, int channel) {
        this.initDigitalInput(slot, channel);
    }

    protected void free() {
        this.m_module.freeDIO(this.m_channel);
    }

    public boolean get() {
        boolean state = this.m_module.getDIO(this.m_channel);
        return state;
    }

    public int getChannel() {
        return this.m_channel;
    }

    public int getChannelForRouting() {
        return DigitalModule.remapDigitalChannel(this.getChannel() - 1);
    }

    public int getModuleForRouting() {
        return DigitalModule.slotToIndex(this.m_module.getSlot());
    }

    public boolean getAnalogTriggerForRouting() {
        return false;
    }

    public void requestInterrupts(Object handler, Object param) {
        try {
            this.m_interruptIndex = interrupts.allocate();
        }
        catch (CheckedAllocationException e) {
            throw new AllocationException("No interrupts are left to be allocated");
        }
        this.allocateInterrupts(false);
        this.m_interrupt.writeConfig_WaitForAck(false);
        this.m_interrupt.writeConfig_Source_AnalogTrigger(this.getAnalogTriggerForRouting());
        this.m_interrupt.writeConfig_Source_Channel((byte)this.getChannelForRouting());
        this.m_interrupt.writeConfig_Source_Module((byte)this.getModuleForRouting());
        this.setUpSourceEdge(true, false);
    }

    public void requestInterrupts() {
        try {
            this.m_interruptIndex = interrupts.allocate();
        }
        catch (CheckedAllocationException e) {
            throw new AllocationException("No interrupts are left to be allocated");
        }
        this.allocateInterrupts(true);
        this.m_interrupt.writeConfig_Source_AnalogTrigger(this.getAnalogTriggerForRouting());
        this.m_interrupt.writeConfig_Source_Channel((byte)this.getChannelForRouting());
        this.m_interrupt.writeConfig_Source_Module((byte)this.getModuleForRouting());
        this.setUpSourceEdge(true, false);
    }

    public void setUpSourceEdge(boolean risingEdge, boolean fallingEdge) {
        if (this.m_interrupt != null) {
            this.m_interrupt.writeConfig_RisingEdge(risingEdge);
            this.m_interrupt.writeConfig_FallingEdge(fallingEdge);
        }
    }
}

