/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.I2C;
import edu.wpi.first.wpilibj.Module;
import edu.wpi.first.wpilibj.Resource;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.fpga.tDIO;
import edu.wpi.first.wpilibj.util.AllocationException;
import edu.wpi.first.wpilibj.util.CheckedAllocationException;

public class DigitalModule
extends Module {
    public static final int kExpectedLoopTiming = 261;
    private static final int[] mapping = new int[]{0, 0, 0, 0, 0, 1, 0, 0};
    private static final Resource DIOChannels = new Resource(28);
    tDIO m_fpgaDIO;
    private final Object syncRoot = new Object();

    public static synchronized DigitalModule getInstance(int slot) {
        SensorBase.checkDigitalModule(slot);
        if (Module.m_modules[slot] == null) {
            Module.m_modules[slot] = new DigitalModule(slot);
        }
        return (DigitalModule)Module.m_modules[slot];
    }

    public static int slotToIndex(int slot) {
        return mapping[slot - 1];
    }

    public static int remapDigitalChannel(int channel) {
        return 15 - channel;
    }

    public static int unmapDigitalChannel(int channel) {
        return 15 - channel;
    }

    protected DigitalModule(int slot) {
        super(slot);
        this.m_fpgaDIO = new tDIO(DigitalModule.slotToIndex(this.m_slot));
        while (tDIO.readLoopTiming() == 0) {
            Timer.delay(0.001);
        }
        if (tDIO.readLoopTiming() != 261) {
            System.out.print("DIO LoopTiming: ");
            System.out.print(tDIO.readLoopTiming());
            System.out.print(", expecting: ");
            System.out.println(261);
        }
        tDIO.writePWMConfig_Period(774);
        tDIO.writePWMConfig_MinHigh(102);
        for (int pwm_index = 1; pwm_index <= 10; ++pwm_index) {
            this.setPWM(pwm_index, 0);
            this.setPWMPeriodScale(pwm_index, 4);
        }
        this.m_fpgaDIO.writeSlowValue_RelayFwd(0);
        this.m_fpgaDIO.writeSlowValue_RelayRev(0);
    }

    public void setPWM(int channel, int value) {
        DigitalModule.checkPWMChannel(channel);
        this.m_fpgaDIO.writePWMValue(channel - 1, value);
    }

    public int getPWM(int channel) {
        DigitalModule.checkPWMChannel(channel);
        return this.m_fpgaDIO.readPWMValue(channel - 1);
    }

    public void setPWMPeriodScale(int channel, int squelchMask) {
        DigitalModule.checkPWMChannel(channel);
        this.m_fpgaDIO.writePWMPeriodScale((byte)(channel - 1), squelchMask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRelayForward(int channel, boolean on) {
        DigitalModule.checkRelayChannel(channel);
        Object object = this.syncRoot;
        synchronized (object) {
            int forwardRelays = this.m_fpgaDIO.readSlowValue_RelayFwd();
            forwardRelays = on ? (forwardRelays |= 1 << channel - 1) : (forwardRelays &= ~(1 << channel - 1));
            this.m_fpgaDIO.writeSlowValue_RelayFwd(forwardRelays);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRelayReverse(int channel, boolean on) {
        SensorBase.checkRelayChannel(channel);
        Object object = this.syncRoot;
        synchronized (object) {
            int reverseRelays = this.m_fpgaDIO.readSlowValue_RelayRev();
            reverseRelays = on ? (reverseRelays |= 1 << channel - 1) : (reverseRelays &= ~(1 << channel - 1));
            this.m_fpgaDIO.writeSlowValue_RelayRev(reverseRelays);
        }
    }

    public boolean getRelayForward(int channel) {
        short forwardRelays = this.m_fpgaDIO.readSlowValue_RelayFwd();
        return (forwardRelays & 1 << channel - 1) != 0;
    }

    public byte getRelayForward() {
        return (byte)this.m_fpgaDIO.readSlowValue_RelayFwd();
    }

    public boolean getRelayReverse(int channel) {
        short reverseRelays = this.m_fpgaDIO.readSlowValue_RelayRev();
        return (reverseRelays & 1 << channel - 1) != 0;
    }

    public byte getRelayReverse() {
        return (byte)this.m_fpgaDIO.readSlowValue_RelayRev();
    }

    public boolean allocateDIO(int channel, boolean input) {
        try {
            DIOChannels.allocate(14 * DigitalModule.slotToIndex(this.m_slot) + channel - 1);
        }
        catch (CheckedAllocationException e) {
            throw new AllocationException("Digital channel " + channel + " on module " + this.m_slot + " is already allocated");
        }
        int outputEnable = this.m_fpgaDIO.readOutputEnable();
        int bitToSet = 1 << DigitalModule.remapDigitalChannel(channel - 1);
        short outputEnableValue = input ? (short)(outputEnable & ~bitToSet) : (short)(outputEnable | bitToSet);
        this.m_fpgaDIO.writeOutputEnable(outputEnableValue);
        return true;
    }

    public void freeDIO(int channel) {
        DIOChannels.free(14 * DigitalModule.slotToIndex(this.m_slot) + channel - 1);
    }

    public void setDIO(int channel, boolean value) {
        int currentDIO = this.m_fpgaDIO.readDO();
        currentDIO = value ? (currentDIO &= ~(1 << DigitalModule.remapDigitalChannel(channel - 1))) : (currentDIO |= 1 << DigitalModule.remapDigitalChannel(channel - 1));
        this.m_fpgaDIO.writeDO(currentDIO);
    }

    public boolean getDIO(int channel) {
        int currentDIO = this.m_fpgaDIO.readDI();
        return (currentDIO >> DigitalModule.remapDigitalChannel(channel - 1) & 1) == 1;
    }

    public short getAllDIO() {
        return (short)this.m_fpgaDIO.readDI();
    }

    public boolean getDIODirection(int channel) {
        int currentOutputEnable = this.m_fpgaDIO.readOutputEnable();
        return (currentOutputEnable >> DigitalModule.remapDigitalChannel(channel - 1) & 1) != 0;
    }

    public short getDIODirection() {
        return (short)this.m_fpgaDIO.readOutputEnable();
    }

    public void pulse(int channel, int pulseLength) {
        short mask = (short)(1 << DigitalModule.remapDigitalChannel(channel - 1));
        this.m_fpgaDIO.writePulseLength(pulseLength);
        this.m_fpgaDIO.writePulse(mask);
    }

    public boolean isPulsing(int channel) {
        int mask = 1 << DigitalModule.remapDigitalChannel(channel - 1);
        int pulseRegister = this.m_fpgaDIO.readPulse();
        return (pulseRegister & mask) != 0;
    }

    public boolean isPulsing() {
        int pulseRegister = this.m_fpgaDIO.readPulse();
        return pulseRegister != 0;
    }

    public I2C getI2C(int address) {
        return new I2C(this, address);
    }
}

