/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.AnalogChannel;
import edu.wpi.first.wpilibj.Dashboard;
import edu.wpi.first.wpilibj.DriverStationEnhancedIO;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.communication.FRCCommonControlData;
import edu.wpi.first.wpilibj.communication.FRCControl;

public class DriverStation {
    public static final int USER_CONTROL_DATA_SIZE = 904;
    public static final int USER_STATUS_DATA_SIZE = 984;
    private static final int WAIT_FOREVER = -1;
    public static final int kBatterySlot = 1;
    public static final int kBatteryChannel = 8;
    public static final int kJoystickPorts = 4;
    public static final int kJoystickAxes = 6;
    private static final double kUpdatePeriod = 0.05;
    private static DriverStation instance = new DriverStation();
    private FRCCommonControlData m_controlData;
    private AnalogChannel m_batteryChannel;
    private Thread m_thread;
    private final Object m_semaphore;
    private int m_digitalOut;
    private boolean m_thread_keepalive = true;
    private Dashboard m_dashboardHigh;
    private Dashboard m_dashboardLow;
    private DriverStationEnhancedIO m_enhancedIO = new DriverStationEnhancedIO();

    public static DriverStation getInstance() {
        return instance;
    }

    protected DriverStation() {
        this.m_controlData = new FRCCommonControlData();
        this.m_semaphore = new Object();
        this.m_dashboardHigh = new Dashboard(this.m_semaphore);
        this.m_dashboardLow = new Dashboard(this.m_semaphore);
        this.m_controlData.packetIndex = 0;
        this.m_controlData.control = 0;
        this.m_controlData.stick0Axes = new byte[]{0, 0, 0, 0, 0, 0};
        this.m_controlData.stick1Axes = new byte[]{0, 0, 0, 0, 0, 0};
        this.m_controlData.stick2Axes = new byte[]{0, 0, 0, 0, 0, 0};
        this.m_controlData.stick3Axes = new byte[]{0, 0, 0, 0, 0, 0};
        this.m_controlData.stick0Buttons = 0;
        this.m_controlData.stick1Buttons = 0;
        this.m_controlData.stick2Buttons = 0;
        this.m_controlData.stick3Buttons = 0;
        this.m_controlData.analog1 = 0;
        this.m_controlData.analog2 = 0;
        this.m_controlData.analog3 = 0;
        this.m_controlData.analog4 = 0;
        this.m_controlData.dsDigitalIn = 0;
        this.m_batteryChannel = new AnalogChannel(1, 8);
        this.m_thread = new Thread((Runnable)new DriverStationTask(this), "FRCDriverStation");
        this.m_thread.start();
    }

    public void release() {
        this.m_thread_keepalive = false;
    }

    private void task() {
        while (this.m_thread_keepalive) {
            this.getData();
            this.m_enhancedIO.updateData();
            this.setData();
            Timer.delay(0.05);
        }
    }

    protected void getData() {
        FRCControl.getCommonControlData(this.m_controlData, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setData() {
        Object object = this.m_semaphore;
        synchronized (object) {
            FRCControl.setStatusData(this.getBatteryVoltage(), this.m_digitalOut, Dashboard.s_updateNumber, this.m_dashboardHigh.m_userStatus.m_bytes, this.m_dashboardHigh.m_userStatusSize, this.m_dashboardLow.m_userStatus.m_bytes, this.m_dashboardLow.m_userStatusSize, -1);
        }
    }

    public double getBatteryVoltage() {
        return this.m_batteryChannel.getAverageVoltage() * 1.68;
    }

    public double getStickAxis(int stick, int axis) {
        byte value;
        if (axis < 1 || axis > 6) {
            return 0.0;
        }
        this.getData();
        switch (stick) {
            case 1: {
                value = this.m_controlData.stick0Axes[axis - 1];
                break;
            }
            case 2: {
                value = this.m_controlData.stick1Axes[axis - 1];
                break;
            }
            case 3: {
                value = this.m_controlData.stick2Axes[axis - 1];
                break;
            }
            case 4: {
                value = this.m_controlData.stick3Axes[axis - 1];
                break;
            }
            default: {
                return 0.0;
            }
        }
        return (double)value / 128.0;
    }

    public int getStickButtons(int stick) {
        this.getData();
        switch (stick) {
            case 1: {
                return this.m_controlData.stick0Buttons;
            }
            case 2: {
                return this.m_controlData.stick1Buttons;
            }
            case 3: {
                return this.m_controlData.stick2Buttons;
            }
            case 4: {
                return this.m_controlData.stick3Buttons;
            }
        }
        return 0;
    }

    public double getAnalogIn(int channel) {
        this.getData();
        switch (channel) {
            case 1: {
                return this.m_controlData.analog1;
            }
            case 2: {
                return this.m_controlData.analog2;
            }
            case 3: {
                return this.m_controlData.analog3;
            }
            case 4: {
                return this.m_controlData.analog4;
            }
        }
        return 0.0;
    }

    public boolean getDigitalIn(int channel) {
        this.getData();
        return (this.m_controlData.dsDigitalIn >> channel - 1 & 1) == 1;
    }

    public void setDigitalOut(int channel, boolean value) {
        this.m_digitalOut &= ~(1 << channel - 1);
        this.m_digitalOut |= (value ? 1 : 0) << channel - 1;
    }

    public boolean getDigitalOut(int channel) {
        return (this.m_digitalOut >> channel - 1 & 1) == 1;
    }

    public boolean isEnabled() {
        this.getData();
        return this.m_controlData.enabled();
    }

    public boolean isDisabled() {
        this.getData();
        return !this.m_controlData.enabled();
    }

    public boolean isAutonomous() {
        this.getData();
        return this.m_controlData.autonomous();
    }

    public boolean isOperatorControl() {
        this.getData();
        return !this.m_controlData.autonomous();
    }

    public int getPacketNumber() {
        this.getData();
        return this.m_controlData.packetIndex;
    }

    public Alliance getAlliance() {
        switch (this.m_controlData.dsID_Alliance) {
            case 'R': {
                return Alliance.kRed;
            }
            case 'B': {
                return Alliance.kBlue;
            }
        }
        return Alliance.kInvalid;
    }

    public int getLocation() {
        return this.m_controlData.dsID_Position - 48;
    }

    public Dashboard getDashboardPackerHigh() {
        return this.m_dashboardHigh;
    }

    public Dashboard getDashboardPackerLow() {
        return this.m_dashboardLow;
    }

    boolean isFMSAttached() {
        return (this.m_controlData.control & 8) > 0;
    }

    public DriverStationEnhancedIO getEnhancedIO() {
        return this.m_enhancedIO;
    }

    public static class Alliance {
        public final int value;
        static final int kRed_val = 0;
        static final int kBlue_val = 1;
        static final int kInvalid_val = 2;
        public static final Alliance kRed = new Alliance(0);
        public static final Alliance kBlue = new Alliance(1);
        public static final Alliance kInvalid = new Alliance(2);

        private Alliance(int value) {
            this.value = value;
        }
    }

    private class DriverStationTask
    implements Runnable {
        private DriverStation m_ds;

        public DriverStationTask(DriverStation ds) {
            this.m_ds = ds;
        }

        public void run() {
            this.m_ds.task();
        }
    }
}

