/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Counter;
import edu.wpi.first.wpilibj.CounterBase;
import edu.wpi.first.wpilibj.DigitalInput;
import edu.wpi.first.wpilibj.DigitalSource;
import edu.wpi.first.wpilibj.Resource;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.fpga.tEncoder;
import edu.wpi.first.wpilibj.util.AllocationException;
import edu.wpi.first.wpilibj.util.CheckedAllocationException;

public class Encoder
extends SensorBase
implements CounterBase {
    static Resource quadEncoders = new Resource(4);
    protected DigitalSource m_aSource;
    protected DigitalSource m_bSource;
    protected DigitalSource m_indexSource = null;
    private tEncoder m_encoder;
    private int m_index;
    private double m_distancePerPulse;
    private Counter m_counter;
    private CounterBase.EncodingType m_encodingType = CounterBase.EncodingType.k4X;
    private boolean m_allocatedA;
    private boolean m_allocatedB;
    private boolean m_allocatedI;

    private void initEncoder(boolean reverseDirection) {
        switch (this.m_encodingType.value) {
            case 2: {
                try {
                    this.m_index = quadEncoders.allocate();
                }
                catch (CheckedAllocationException e) {
                    throw new AllocationException("There are no encoders left to allocate");
                }
                this.m_encoder = new tEncoder(this.m_index);
                this.m_encoder.writeConfig_ASource_Module(this.m_aSource.getModuleForRouting());
                this.m_encoder.writeConfig_ASource_Channel(this.m_aSource.getChannelForRouting());
                this.m_encoder.writeConfig_ASource_AnalogTrigger(this.m_aSource.getAnalogTriggerForRouting());
                this.m_encoder.writeConfig_BSource_Module(this.m_bSource.getModuleForRouting());
                this.m_encoder.writeConfig_BSource_Channel(this.m_bSource.getChannelForRouting());
                this.m_encoder.writeConfig_BSource_AnalogTrigger(this.m_bSource.getAnalogTriggerForRouting());
                this.m_encoder.strobeReset();
                this.m_encoder.writeConfig_Reverse(reverseDirection);
                this.m_encoder.writeTimerConfig_AverageSize(1);
                if (this.m_indexSource != null) {
                    this.m_encoder.writeConfig_IndexSource_Module(this.m_indexSource.getModuleForRouting());
                    this.m_encoder.writeConfig_IndexSource_Channel(this.m_indexSource.getChannelForRouting());
                    this.m_encoder.writeConfig_IndexSource_AnalogTrigger(this.m_indexSource.getAnalogTriggerForRouting());
                    this.m_encoder.writeConfig_IndexActiveHigh(true);
                }
                this.m_counter = null;
                break;
            }
            case 0: 
            case 1: {
                this.m_counter = new Counter(this.m_encodingType, this.m_aSource, this.m_bSource, reverseDirection);
            }
        }
        this.m_distancePerPulse = 1.0;
    }

    public Encoder(int aSlot, int aChannel, int bSlot, int bChannel, boolean reverseDirection) {
        this.m_allocatedA = true;
        this.m_allocatedB = true;
        this.m_allocatedI = false;
        this.m_aSource = new DigitalInput(aSlot, aChannel);
        this.m_bSource = new DigitalInput(bSlot, bChannel);
        this.initEncoder(reverseDirection);
    }

    public Encoder(int aSlot, int aChannel, int bSlot, int bChannel) {
        this(aSlot, aChannel, bSlot, bChannel, false);
    }

    public Encoder(int aSlot, int aChannel, int bSlot, int bChannel, boolean reverseDirection, CounterBase.EncodingType encodingType) {
        this.m_allocatedA = true;
        this.m_allocatedB = true;
        this.m_allocatedI = false;
        this.m_aSource = new DigitalInput(aSlot, aChannel);
        this.m_bSource = new DigitalInput(bSlot, bChannel);
        if (encodingType == null) {
            throw new NullPointerException("Given encoding type was null");
        }
        this.m_encodingType = encodingType;
        this.initEncoder(reverseDirection);
    }

    public Encoder(int aSlot, int aChannel, int bSlot, int bChannel, int indexSlot, int indexChannel, boolean reverseDirection) {
        this.m_allocatedA = true;
        this.m_allocatedB = true;
        this.m_allocatedI = true;
        this.m_aSource = new DigitalInput(aSlot, aChannel);
        this.m_bSource = new DigitalInput(bSlot, bChannel);
        this.m_indexSource = new DigitalInput(indexSlot, indexChannel);
        this.initEncoder(reverseDirection);
    }

    public Encoder(int aSlot, int aChannel, int bSlot, int bChannel, int indexSlot, int indexChannel) {
        this(aSlot, aChannel, bSlot, bChannel, indexSlot, indexChannel, false);
    }

    public Encoder(int aChannel, int bChannel, boolean reverseDirection) {
        this.m_allocatedA = true;
        this.m_allocatedB = true;
        this.m_allocatedI = false;
        this.m_aSource = new DigitalInput(aChannel);
        this.m_bSource = new DigitalInput(bChannel);
        this.initEncoder(reverseDirection);
    }

    public Encoder(int aChannel, int bChannel) {
        this(aChannel, bChannel, false);
    }

    public Encoder(int aChannel, int bChannel, boolean reverseDirection, CounterBase.EncodingType encodingType) {
        this.m_allocatedA = true;
        this.m_allocatedB = true;
        this.m_allocatedI = false;
        if (encodingType == null) {
            throw new NullPointerException("Given encoding type was null");
        }
        this.m_encodingType = encodingType;
        this.m_aSource = new DigitalInput(aChannel);
        this.m_bSource = new DigitalInput(bChannel);
        this.initEncoder(reverseDirection);
    }

    public Encoder(int aChannel, int bChannel, int indexChannel, boolean reverseDirection) {
        this.m_allocatedA = true;
        this.m_allocatedB = true;
        this.m_allocatedI = true;
        this.m_aSource = new DigitalInput(aChannel);
        this.m_bSource = new DigitalInput(bChannel);
        this.m_indexSource = new DigitalInput(indexChannel);
        this.initEncoder(reverseDirection);
    }

    public Encoder(int aChannel, int bChannel, int indexChannel) {
        this(aChannel, bChannel, indexChannel, false);
    }

    public Encoder(DigitalSource aSource, DigitalSource bSource, boolean reverseDirection) {
        this.m_allocatedA = false;
        this.m_allocatedB = false;
        this.m_allocatedI = false;
        if (aSource == null) {
            throw new NullPointerException("Digital Source A was null");
        }
        this.m_aSource = aSource;
        if (bSource == null) {
            throw new NullPointerException("Digital Source B was null");
        }
        this.m_bSource = bSource;
        this.initEncoder(reverseDirection);
    }

    public Encoder(DigitalSource aSource, DigitalSource bSource) {
        this(aSource, bSource, false);
    }

    public Encoder(DigitalSource aSource, DigitalSource bSource, boolean reverseDirection, CounterBase.EncodingType encodingType) {
        this.m_allocatedA = false;
        this.m_allocatedB = false;
        this.m_allocatedI = false;
        if (encodingType == null) {
            throw new NullPointerException("Given encoding type was null");
        }
        this.m_encodingType = encodingType;
        if (aSource == null) {
            throw new NullPointerException("Digital Source A was null");
        }
        this.m_aSource = aSource;
        if (bSource == null) {
            throw new NullPointerException("Digital Source B was null");
        }
        this.m_aSource = aSource;
        this.m_bSource = bSource;
        this.initEncoder(reverseDirection);
    }

    public Encoder(DigitalSource aSource, DigitalSource bSource, DigitalSource indexSource, boolean reverseDirection) {
        this.m_allocatedA = false;
        this.m_allocatedB = false;
        this.m_allocatedI = false;
        if (aSource == null) {
            throw new NullPointerException("Digital Source A was null");
        }
        this.m_aSource = aSource;
        if (bSource == null) {
            throw new NullPointerException("Digital Source B was null");
        }
        this.m_aSource = aSource;
        this.m_bSource = bSource;
        this.m_indexSource = indexSource;
        this.initEncoder(reverseDirection);
    }

    public Encoder(DigitalSource aSource, DigitalSource bSource, DigitalSource indexSource) {
        this(aSource, bSource, indexSource, false);
    }

    protected void free() {
        if (this.m_aSource != null && this.m_allocatedA) {
            this.m_aSource.free();
            this.m_allocatedA = false;
        }
        if (this.m_bSource != null && this.m_allocatedB) {
            this.m_bSource.free();
            this.m_allocatedB = false;
        }
        if (this.m_indexSource != null && this.m_allocatedI) {
            this.m_indexSource.free();
            this.m_allocatedI = false;
        }
        this.m_aSource = null;
        this.m_bSource = null;
        this.m_indexSource = null;
        if (this.m_counter != null) {
            this.m_counter.free();
            this.m_counter = null;
        } else {
            this.m_encoder.Release();
            quadEncoders.free(this.m_index);
            this.m_encoder = null;
        }
    }

    public void start() {
        if (this.m_counter != null) {
            this.m_counter.start();
        } else {
            this.m_encoder.writeConfig_Enable(true);
        }
    }

    public void stop() {
        if (this.m_counter != null) {
            this.m_counter.stop();
        } else {
            this.m_encoder.writeConfig_Enable(false);
        }
    }

    public int getRaw() {
        int value = this.m_counter != null ? this.m_counter.get() : this.m_encoder.readOutput_Value();
        return value;
    }

    public int get() {
        return (int)((double)this.getRaw() * this.decodingScaleFactor());
    }

    public void reset() {
        if (this.m_counter != null) {
            this.m_counter.reset();
        } else {
            this.m_encoder.strobeReset();
        }
    }

    public double getPeriod() {
        if (this.m_counter != null) {
            return this.m_counter.getPeriod() * this.decodingScaleFactor();
        }
        if (this.m_encoder.readTimerOutput_Stalled()) {
            return Double.POSITIVE_INFINITY;
        }
        double value = (double)this.m_encoder.readTimerOutput_Period() / (double)this.m_encoder.readTimerOutput_Count();
        return value * 1.0E-6 / (this.decodingScaleFactor() * 4.0);
    }

    public void setMaxPeriod(double maxPeriod) {
        if (this.m_counter != null) {
            this.m_counter.setMaxPeriod(maxPeriod * this.decodingScaleFactor());
        } else {
            this.m_encoder.writeTimerConfig_StallPeriod((int)(maxPeriod * 1000000.0 * this.decodingScaleFactor()));
        }
    }

    public boolean getStopped() {
        if (this.m_counter != null) {
            return this.m_counter.getStopped();
        }
        boolean value = this.m_encoder.readTimerOutput_Stalled();
        return value;
    }

    public boolean getDirection() {
        if (this.m_counter != null) {
            return this.m_counter.getDirection();
        }
        boolean value = this.m_encoder.readOutput_Direction();
        return value;
    }

    private double decodingScaleFactor() {
        switch (this.m_encodingType.value) {
            case 0: {
                return 1.0;
            }
            case 1: {
                return 0.5;
            }
            case 2: {
                return 0.25;
            }
        }
        return 0.0;
    }

    public double getDistance() {
        return (double)this.getRaw() * this.decodingScaleFactor() * this.m_distancePerPulse;
    }

    public double getRate() {
        return this.m_distancePerPulse / this.getPeriod() * (this.getDirection() ? 1.0 : -1.0);
    }

    public void setMinRate(double minRate) {
        this.setMaxPeriod(this.m_distancePerPulse / minRate);
    }

    public void setDistancePerPulse(double distancePerPulse) {
        this.m_distancePerPulse = distancePerPulse;
    }

    public void setReverseDirection(boolean reverseDirection) {
        if (this.m_counter != null) {
            this.m_counter.setReverseDirection(reverseDirection);
        } else {
            this.m_encoder.writeConfig_Reverse(reverseDirection);
        }
    }
}

