/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.Watchdog;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public abstract class RobotBase
extends MIDlet {
    private final DriverStation m_ds;
    private final Watchdog m_watchdog = Watchdog.getInstance();
    private int previousPacketNumber;

    protected RobotBase() {
        this.m_ds = DriverStation.getInstance();
    }

    protected void free() {
    }

    public boolean isSystemActive() {
        return this.m_watchdog.isSystemActive();
    }

    public Watchdog getWatchdog() {
        return this.m_watchdog;
    }

    public boolean isDisabled() {
        return this.m_ds.isDisabled();
    }

    public boolean isEnabled() {
        return this.m_ds.isEnabled();
    }

    public boolean isAutonomous() {
        return this.m_ds.isAutonomous();
    }

    public boolean isOperatorControl() {
        return this.m_ds.isOperatorControl();
    }

    public boolean isNewDataAvailable() {
        if (this.m_ds.getPacketNumber() == this.previousPacketNumber) {
            return false;
        }
        this.previousPacketNumber = this.m_ds.getPacketNumber();
        return true;
    }

    public abstract void startCompetition();

    protected final void startApp() throws MIDletStateChangeException {
        Watchdog.getInstance().setExpiration(0.1);
        Watchdog.getInstance().setEnabled(true);
        try {
            this.startCompetition();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        while (true) {
            try {
                while (true) {
                    Thread.sleep(10000L);
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    protected final void pauseApp() {
    }

    protected final void destroyApp(boolean unconditional) throws MIDletStateChangeException {
    }
}

