/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import com.sun.squawk.util.MathUtils;
import edu.wpi.first.wpilibj.GenericHID;
import edu.wpi.first.wpilibj.Jaguar;
import edu.wpi.first.wpilibj.PWM;
import edu.wpi.first.wpilibj.SpeedController;

public class RobotDrive {
    public static final double kDefaultSensitivity = 0.5;
    private static final int kMaxNumberOfMotors = 4;
    private final int[] m_invertedMotors = new int[4];
    private double m_sensitivity;
    private SpeedController m_frontLeftMotor;
    private SpeedController m_frontRightMotor;
    private SpeedController m_rearLeftMotor;
    private SpeedController m_rearRightMotor;
    private boolean m_allocatedSpeedControllers;

    public RobotDrive(int leftMotorChannel, int rightMotorChannel, double sensitivity) {
        this.m_sensitivity = sensitivity;
        this.m_frontLeftMotor = null;
        this.m_rearLeftMotor = new Jaguar(leftMotorChannel);
        this.m_frontRightMotor = null;
        this.m_rearRightMotor = new Jaguar(rightMotorChannel);
        for (int i = 0; i < 4; ++i) {
            this.m_invertedMotors[i] = 1;
        }
        this.drive(0.0, 0.0);
        this.m_allocatedSpeedControllers = true;
    }

    public RobotDrive(int leftMotorChannel, int rightMotorChannel) {
        this(leftMotorChannel, rightMotorChannel, 0.5);
    }

    public RobotDrive(int frontLeftMotor, int rearLeftMotor, int frontRightMotor, int rearRightMotor, double sensitivity) {
        this.m_sensitivity = sensitivity;
        this.m_rearLeftMotor = new Jaguar(rearLeftMotor);
        this.m_rearRightMotor = new Jaguar(rearRightMotor);
        this.m_frontLeftMotor = new Jaguar(frontLeftMotor);
        this.m_frontRightMotor = new Jaguar(frontRightMotor);
        for (int i = 0; i < 4; ++i) {
            this.m_invertedMotors[i] = 1;
        }
        this.drive(0.0, 0.0);
        this.m_allocatedSpeedControllers = true;
    }

    public RobotDrive(int frontLeftMotor, int rearLeftMotor, int frontRightMotor, int rearRightMotor) {
        this(frontLeftMotor, rearLeftMotor, frontRightMotor, rearRightMotor, 0.5);
    }

    public RobotDrive(SpeedController leftMotor, SpeedController rightMotor, double sensitivity) {
        if (leftMotor == null || rightMotor == null) {
            this.m_rearRightMotor = null;
            this.m_rearLeftMotor = null;
            throw new NullPointerException("Null motor provided");
        }
        this.m_frontLeftMotor = null;
        this.m_rearLeftMotor = leftMotor;
        this.m_frontRightMotor = null;
        this.m_rearRightMotor = rightMotor;
        this.m_sensitivity = sensitivity;
        for (int i = 0; i < 4; ++i) {
            this.m_invertedMotors[i] = 1;
        }
        this.m_allocatedSpeedControllers = false;
    }

    public RobotDrive(SpeedController leftMotor, SpeedController rightMotor) {
        this(leftMotor, rightMotor, 0.5);
    }

    public RobotDrive(SpeedController frontLeftMotor, SpeedController rearLeftMotor, SpeedController frontRightMotor, SpeedController rearRightMotor, double sensitivity) {
        if (frontLeftMotor == null || rearLeftMotor == null || frontRightMotor == null || rearRightMotor == null) {
            this.m_rearRightMotor = null;
            this.m_frontRightMotor = null;
            this.m_rearLeftMotor = null;
            this.m_frontLeftMotor = null;
            throw new NullPointerException("Null motor provided");
        }
        this.m_frontLeftMotor = frontLeftMotor;
        this.m_rearLeftMotor = rearLeftMotor;
        this.m_frontRightMotor = frontRightMotor;
        this.m_rearRightMotor = rearRightMotor;
        this.m_sensitivity = sensitivity;
        for (int i = 0; i < 4; ++i) {
            this.m_invertedMotors[i] = 1;
        }
        this.m_allocatedSpeedControllers = false;
    }

    public RobotDrive(SpeedController frontLeftMotor, SpeedController rearLeftMotor, SpeedController frontRightMotor, SpeedController rearRightMotor) {
        this(frontLeftMotor, rearLeftMotor, frontRightMotor, rearRightMotor, 0.5);
    }

    public void drive(double speed, double curve) {
        double rightSpeed;
        double leftSpeed;
        if (curve < 0.0) {
            double value = MathUtils.log((double)(-curve));
            double ratio = (value - this.m_sensitivity) / (value + this.m_sensitivity);
            if (ratio == 0.0) {
                ratio = 1.0E-10;
            }
            leftSpeed = speed / ratio;
            rightSpeed = speed;
        } else if (curve > 0.0) {
            double value = MathUtils.log((double)curve);
            double ratio = (value - this.m_sensitivity) / (value + this.m_sensitivity);
            if (ratio == 0.0) {
                ratio = 1.0E-10;
            }
            leftSpeed = speed;
            rightSpeed = speed / ratio;
        } else {
            leftSpeed = speed;
            rightSpeed = speed;
        }
        this.setLeftRightMotorSpeeds(leftSpeed, rightSpeed);
    }

    public void tankDrive(GenericHID leftStick, GenericHID rightStick) {
        if (leftStick == null || rightStick == null) {
            throw new NullPointerException("Null HID provided");
        }
        this.tankDrive(leftStick.getY(), rightStick.getY());
    }

    public void tankDrive(GenericHID leftStick, int leftAxis, GenericHID rightStick, int rightAxis) {
        if (leftStick == null || rightStick == null) {
            throw new NullPointerException("Null HID provided");
        }
        this.tankDrive(leftStick.getRawAxis(leftAxis), rightStick.getRawAxis(rightAxis));
    }

    public void tankDrive(double leftValue, double rightValue) {
        leftValue = this.limit(leftValue);
        rightValue = this.limit(rightValue);
        leftValue = leftValue >= 0.0 ? (leftValue *= leftValue) : -(leftValue * leftValue);
        rightValue = rightValue >= 0.0 ? (rightValue *= rightValue) : -(rightValue * rightValue);
        this.setLeftRightMotorSpeeds(leftValue, rightValue);
    }

    public void arcadeDrive(GenericHID stick, boolean squaredInputs) {
        this.arcadeDrive(stick.getY(), stick.getX(), squaredInputs);
    }

    public void arcadeDrive(GenericHID stick) {
        this.arcadeDrive(stick, true);
    }

    public void arcadeDrive(GenericHID moveStick, int moveAxis, GenericHID rotateStick, int rotateAxis, boolean squaredInputs) {
        double moveValue = moveStick.getRawAxis(moveAxis);
        double rotateValue = rotateStick.getRawAxis(rotateAxis);
        this.arcadeDrive(moveValue, rotateValue, squaredInputs);
    }

    public void arcadeDrive(GenericHID moveStick, int moveAxis, GenericHID rotateStick, int rotateAxis) {
        this.arcadeDrive(moveStick, moveAxis, rotateStick, rotateAxis, true);
    }

    public void arcadeDrive(double moveValue, double rotateValue, boolean squaredInputs) {
        double rightMotorSpeed;
        double leftMotorSpeed;
        moveValue = this.limit(moveValue);
        rotateValue = this.limit(rotateValue);
        if (squaredInputs) {
            moveValue = moveValue >= 0.0 ? (moveValue *= moveValue) : -(moveValue * moveValue);
            rotateValue = rotateValue >= 0.0 ? (rotateValue *= rotateValue) : -(rotateValue * rotateValue);
        }
        if (moveValue > 0.0) {
            if (rotateValue > 0.0) {
                leftMotorSpeed = moveValue - rotateValue;
                rightMotorSpeed = Math.max(moveValue, rotateValue);
            } else {
                leftMotorSpeed = Math.max(moveValue, -rotateValue);
                rightMotorSpeed = moveValue + rotateValue;
            }
        } else if (rotateValue > 0.0) {
            leftMotorSpeed = -Math.max(-moveValue, rotateValue);
            rightMotorSpeed = moveValue + rotateValue;
        } else {
            leftMotorSpeed = moveValue - rotateValue;
            rightMotorSpeed = -Math.max(-moveValue, -rotateValue);
        }
        this.setLeftRightMotorSpeeds(leftMotorSpeed, rightMotorSpeed);
    }

    public void arcadeDrive(double moveValue, double rotateValue) {
        this.arcadeDrive(moveValue, rotateValue, true);
    }

    public void holonomicDrive(double magnitude, double direction, double rotation) {
        magnitude = this.limit(magnitude);
        double cosD = Math.cos((direction + 45.0) * 3.14159 / 180.0);
        double sinD = Math.cos((direction - 45.0) * 3.14159 / 180.0);
        double frontLeftSpeed = this.limit(sinD * magnitude + rotation);
        double rearLeftSpeed = this.limit(cosD * magnitude + rotation);
        double frontRightSpeed = this.limit(cosD * magnitude - rotation);
        double rearRightSpeed = this.limit(sinD * magnitude - rotation);
        this.m_frontLeftMotor.set(frontLeftSpeed * (double)this.m_invertedMotors[0]);
        this.m_frontRightMotor.set(frontRightSpeed * (double)this.m_invertedMotors[1]);
        this.m_rearLeftMotor.set(rearLeftSpeed * (double)this.m_invertedMotors[2]);
        this.m_rearRightMotor.set(rearRightSpeed * (double)this.m_invertedMotors[3]);
    }

    public void setLeftRightMotorSpeeds(double leftSpeed, double rightSpeed) {
        if (this.m_rearLeftMotor == null || this.m_rearRightMotor == null) {
            throw new NullPointerException("Null motor provided");
        }
        leftSpeed = this.limit(leftSpeed);
        rightSpeed = this.limit(rightSpeed);
        if (this.m_frontLeftMotor != null) {
            this.m_frontLeftMotor.set(leftSpeed * (double)this.m_invertedMotors[0]);
        }
        this.m_rearLeftMotor.set(leftSpeed * (double)this.m_invertedMotors[2]);
        if (this.m_frontRightMotor != null) {
            this.m_frontRightMotor.set(-rightSpeed * (double)this.m_invertedMotors[1]);
        }
        this.m_rearRightMotor.set(-rightSpeed * (double)this.m_invertedMotors[3]);
    }

    private double limit(double num) {
        if (num > 1.0) {
            return 1.0;
        }
        if (num < -1.0) {
            return -1.0;
        }
        return num;
    }

    public void setInvertedMotor(MotorType motor, boolean isInverted) {
        this.m_invertedMotors[motor.value] = isInverted ? -1 : 1;
    }

    protected void free() {
        if (this.m_allocatedSpeedControllers) {
            if (this.m_frontLeftMotor != null) {
                ((PWM)((Object)this.m_frontLeftMotor)).free();
            }
            if (this.m_frontRightMotor != null) {
                ((PWM)((Object)this.m_frontRightMotor)).free();
            }
            if (this.m_rearLeftMotor != null) {
                ((PWM)((Object)this.m_rearLeftMotor)).free();
            }
            if (this.m_rearRightMotor != null) {
                ((PWM)((Object)this.m_rearRightMotor)).free();
            }
        }
    }

    public static class MotorType {
        public final int value;
        static final int kFrontLeft_val = 0;
        static final int kFrontRight_val = 1;
        static final int kRearLeft_val = 2;
        static final int kRearRight_val = 3;
        public static final MotorType kFrontLeft = new MotorType(0);
        public static final MotorType kFrontRight = new MotorType(1);
        public static final MotorType kRearLeft = new MotorType(2);
        public static final MotorType kRearRight = new MotorType(3);

        private MotorType(int value) {
            this.value = value;
        }
    }
}

