/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Resource;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.fpga.tSolenoid;
import edu.wpi.first.wpilibj.util.AllocationException;
import edu.wpi.first.wpilibj.util.CheckedAllocationException;

public class Solenoid
extends SensorBase {
    private static Resource allocated = new Resource(16);
    private int m_chassisSlot;
    private int m_channel;
    private static tSolenoid m_fpgaSolenoidModule;
    private static int m_refCount;

    private synchronized void initSolenoid() {
        Solenoid.checkSolenoidModule(this.m_chassisSlot);
        Solenoid.checkSolenoidChannel(this.m_channel);
        if (++m_refCount == 1) {
            m_fpgaSolenoidModule = new tSolenoid();
        }
        try {
            allocated.allocate(Solenoid.slotToIndex(this.m_chassisSlot) * 8 + this.m_channel - 1);
        }
        catch (CheckedAllocationException e) {
            throw new AllocationException("Solenoid channel " + this.m_channel + " on module " + this.m_chassisSlot + " is already allocated");
        }
    }

    public Solenoid(int channel) {
        this.m_chassisSlot = Solenoid.getDefaultSolenoidModule();
        this.m_channel = channel;
        this.initSolenoid();
    }

    public Solenoid(int slot, int channel) {
        this.m_chassisSlot = slot;
        this.m_channel = channel;
        this.initSolenoid();
    }

    protected synchronized void free() {
        allocated.free(Solenoid.slotToIndex(this.m_chassisSlot) * 8 + this.m_channel - 1);
        if (m_refCount == 1) {
            m_fpgaSolenoidModule.Release();
            m_fpgaSolenoidModule = null;
        }
        --m_refCount;
    }

    public static int slotToIndex(int slot) {
        return 8 - slot;
    }

    public synchronized void set(boolean on) {
        int value = tSolenoid.readDO7_0(Solenoid.slotToIndex(this.m_chassisSlot));
        value = on ? (value |= 1 << this.m_channel - 1) : (value &= ~(1 << this.m_channel - 1));
        tSolenoid.writeDO7_0(Solenoid.slotToIndex(this.m_chassisSlot), value);
    }

    public boolean get() {
        int value = tSolenoid.readDO7_0(Solenoid.slotToIndex(this.m_chassisSlot)) & 1 << this.m_channel - 1;
        return value != 0;
    }

    public static byte getAll() {
        return (byte)tSolenoid.readDO7_0(Solenoid.slotToIndex(Solenoid.getDefaultSolenoidModule()));
    }
}

