/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.communication;

import com.sun.cldc.jna.Structure;

public final class FRCCommonControlData
extends Structure {
    public static final short RESET_BIT = 128;
    public static final short ESTOP_BIT = 64;
    public static final short ENABLED_BIT = 32;
    public static final short AUTONOMOUS_BIT = 16;
    public static final short FMS_ATTATCHED = 8;
    public static final short RESYNCH = 4;
    public static final short CRIO_CHECK_SUM = 2;
    public static final short FPGA_CHECK_SUM = 1;
    public short packetIndex;
    public byte control;
    public byte dsDigitalIn;
    public short teamID;
    public char dsID_Alliance;
    public char dsID_Position;
    public byte[] stick0Axes = new byte[6];
    public short stick0Buttons;
    public byte[] stick1Axes = new byte[6];
    public short stick1Buttons;
    public byte[] stick2Axes = new byte[6];
    public short stick2Buttons;
    public byte[] stick3Axes = new byte[6];
    public short stick3Buttons;
    public short analog1;
    public short analog2;
    public short analog3;
    public short analog4;
    public long cRIOChecksum;
    public int FPGAChecksum0;
    public int FPGAChecksum1;
    public int FPGAChecksum2;
    public int FPGAChecksum3;
    public final char[] versionData = new char[8];

    public boolean enabled() {
        return (this.control & 0x20) == 32;
    }

    public boolean autonomous() {
        return (this.control & 0x10) == 16;
    }

    public FRCCommonControlData() {
        this.allocateMemory();
    }

    protected void free() {
        this.freeMemory();
    }

    public void read() {
        this.packetIndex = this.backingNativeMemory.getShort(0L);
        this.control = this.backingNativeMemory.getByte(2L);
        this.dsDigitalIn = this.backingNativeMemory.getByte(3L);
        this.teamID = this.backingNativeMemory.getShort(4L);
        this.dsID_Alliance = (char)this.backingNativeMemory.getByte(6L);
        this.dsID_Position = (char)this.backingNativeMemory.getByte(7L);
        this.backingNativeMemory.getBytes(8L, this.stick0Axes, 0, 6);
        this.stick0Buttons = this.backingNativeMemory.getShort(14L);
        this.backingNativeMemory.getBytes(16L, this.stick1Axes, 0, 6);
        this.stick1Buttons = this.backingNativeMemory.getShort(22L);
        this.backingNativeMemory.getBytes(24L, this.stick2Axes, 0, 6);
        this.stick2Buttons = this.backingNativeMemory.getShort(30L);
        this.backingNativeMemory.getBytes(32L, this.stick3Axes, 0, 6);
        this.stick3Buttons = this.backingNativeMemory.getShort(38L);
        this.analog1 = this.backingNativeMemory.getShort(40L);
        this.analog2 = this.backingNativeMemory.getShort(42L);
        this.analog3 = this.backingNativeMemory.getShort(44L);
        this.analog4 = this.backingNativeMemory.getShort(46L);
        this.cRIOChecksum = this.backingNativeMemory.getLong(48L);
        this.FPGAChecksum0 = this.backingNativeMemory.getInt(56L);
        this.FPGAChecksum1 = this.backingNativeMemory.getInt(60L);
        this.FPGAChecksum2 = this.backingNativeMemory.getInt(64L);
        this.FPGAChecksum3 = this.backingNativeMemory.getInt(68L);
        byte[] versionDataBytes = new byte[8];
        this.backingNativeMemory.getBytes(72L, versionDataBytes, 0, 8);
        for (int i = 0; i < versionDataBytes.length; ++i) {
            this.versionData[i] = (char)versionDataBytes[i];
        }
    }

    public void write() {
        this.backingNativeMemory.setShort(0L, this.packetIndex);
        this.backingNativeMemory.setByte(2L, this.control);
        this.backingNativeMemory.setByte(3L, this.dsDigitalIn);
        this.backingNativeMemory.setShort(4L, this.teamID);
        this.backingNativeMemory.setByte(6L, (byte)this.dsID_Alliance);
        this.backingNativeMemory.setByte(7L, (byte)this.dsID_Position);
        this.backingNativeMemory.setBytes(8L, this.stick0Axes, 0, 6);
        this.backingNativeMemory.setShort(14L, this.stick0Buttons);
        this.backingNativeMemory.setBytes(16L, this.stick1Axes, 0, 6);
        this.backingNativeMemory.setShort(22L, this.stick1Buttons);
        this.backingNativeMemory.setBytes(24L, this.stick2Axes, 0, 6);
        this.backingNativeMemory.setShort(30L, this.stick2Buttons);
        this.backingNativeMemory.setBytes(32L, this.stick3Axes, 0, 6);
        this.backingNativeMemory.setShort(38L, this.stick3Buttons);
        this.backingNativeMemory.setShort(40L, this.analog1);
        this.backingNativeMemory.setShort(42L, this.analog2);
        this.backingNativeMemory.setShort(44L, this.analog3);
        this.backingNativeMemory.setShort(46L, this.analog4);
        this.backingNativeMemory.setLong(48L, this.cRIOChecksum);
        this.backingNativeMemory.setInt(56L, this.FPGAChecksum0);
        this.backingNativeMemory.setInt(60L, this.FPGAChecksum1);
        this.backingNativeMemory.setInt(64L, this.FPGAChecksum2);
        this.backingNativeMemory.setInt(68L, this.FPGAChecksum3);
        byte[] versionDataBytes = new byte[8];
        for (int i = 0; i < versionDataBytes.length; ++i) {
            versionDataBytes[i] = (byte)this.versionData[i];
        }
        this.backingNativeMemory.setBytes(72L, versionDataBytes, 0, 8);
    }

    public int size() {
        return 80;
    }
}

