/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.fpga;

import com.ni.rio.NiRioSrv;
import edu.wpi.first.wpilibj.fpga.tSystem;

public class tDIO
extends tSystem {
    public static final int kNumSystems = 2;
    public final int m_SystemIndex;
    private static final int kDIO0_DO_Address = 33612;
    private static final int kDIO1_DO_Address = 33512;
    private static final int[] kDO_Addresses = new int[]{33612, 33512};
    private static final int kDIO0_I2CDataToSend_Address = 33556;
    private static final int kDIO1_I2CDataToSend_Address = 33456;
    private static final int[] kI2CDataToSend_Addresses = new int[]{33556, 33456};
    public static final int kFilterSelect_NumElements = 16;
    public static final int kFilterSelect_ElementSize = 2;
    public static final int kFilterSelect_ElementMask = 3;
    private static final int kDIO0_FilterSelect_Address = 33516;
    private static final int kDIO1_FilterSelect_Address = 33416;
    private static final int[] kFilterSelect_Addresses = new int[]{33516, 33416};
    public static final int kFilterPeriod_NumElements = 3;
    public static final int kFilterPeriod_ElementSize = 8;
    public static final int kFilterPeriod_ElementMask = 255;
    private static final int kDIO0_FilterPeriod_Address = 33520;
    private static final int kDIO1_FilterPeriod_Address = 33420;
    private static final int[] kFilterPeriod_Addresses = new int[]{33520, 33420};
    private static final int kDIO0_OutputEnable_Address = 33604;
    private static final int kDIO1_OutputEnable_Address = 33504;
    private static final int[] kOutputEnable_Addresses = new int[]{33604, 33504};
    private static final int kDIO0_DI_Address = 33608;
    private static final int kDIO1_DI_Address = 33508;
    private static final int[] kDI_Addresses = new int[]{33608, 33508};
    private static final int kDIO0_I2CDataReceived_Address = 33544;
    private static final int kDIO1_I2CDataReceived_Address = 33444;
    private static final int[] kI2CDataReceived_Addresses = new int[]{33544, 33444};
    private static final int kI2CStatus_Transaction_BitfieldMask = 0x4000000;
    private static final int kI2CStatus_Transaction_BitfieldOffset = 26;
    private static final int kI2CStatus_Done_BitfieldMask = 0x2000000;
    private static final int kI2CStatus_Done_BitfieldOffset = 25;
    private static final int kI2CStatus_Aborted_BitfieldMask = 0x1000000;
    private static final int kI2CStatus_Aborted_BitfieldOffset = 24;
    private static final int kI2CStatus_DataReceivedHigh_BitfieldMask = 0xFFFFFF;
    private static final int kI2CStatus_DataReceivedHigh_BitfieldOffset = 0;
    private static final int kDIO0_I2CStatus_Address = 33540;
    private static final int kDIO1_I2CStatus_Address = 33440;
    private static final int[] kI2CStatus_Addresses = new int[]{33540, 33440};
    private static final int kSlowValue_RelayFwd_BitfieldMask = 1044480;
    private static final int kSlowValue_RelayFwd_BitfieldOffset = 12;
    private static final int kSlowValue_RelayRev_BitfieldMask = 4080;
    private static final int kSlowValue_RelayRev_BitfieldOffset = 4;
    private static final int kSlowValue_I2CHeader_BitfieldMask = 15;
    private static final int kSlowValue_I2CHeader_BitfieldOffset = 0;
    private static final int kDIO0_SlowValue_Address = 33536;
    private static final int kDIO1_SlowValue_Address = 33436;
    private static final int[] kSlowValue_Addresses = new int[]{33536, 33436};
    public static final int kPWMPeriodScale_NumElements = 10;
    public static final int kPWMPeriodScale_ElementSize = 2;
    public static final int kPWMPeriodScale_ElementMask = 3;
    private static final int kDIO0_PWMPeriodScale_Address = 33560;
    private static final int kDIO1_PWMPeriodScale_Address = 33460;
    private static final int[] kPWMPeriodScale_Addresses = new int[]{33560, 33460};
    private static final int kDIO0_Pulse_Address = 33528;
    private static final int kDIO1_Pulse_Address = 33428;
    private static final int[] kPulse_Addresses = new int[]{33528, 33428};
    private static final int kDIO0_I2CStart_Address = 33548;
    private static final int kDIO1_I2CStart_Address = 33448;
    private static final int[] kI2CStart_Addresses = new int[]{33548, 33448};
    private static final int kDIO0_BFL_Address = 33532;
    private static final int kDIO1_BFL_Address = 33432;
    private static final int[] kBFL_Addresses = new int[]{33532, 33432};
    private static final int kDIO0_PulseLength_Address = 33524;
    private static final int kDIO1_PulseLength_Address = 33424;
    private static final int[] kPulseLength_Addresses = new int[]{33524, 33424};
    private static final int kI2CConfig_Address_BitfieldMask = 1069547520;
    private static final int kI2CConfig_Address_BitfieldOffset = 22;
    private static final int kI2CConfig_BytesToRead_BitfieldMask = 0x380000;
    private static final int kI2CConfig_BytesToRead_BitfieldOffset = 19;
    private static final int kI2CConfig_BytesToWrite_BitfieldMask = 458752;
    private static final int kI2CConfig_BytesToWrite_BitfieldOffset = 16;
    private static final int kI2CConfig_DataToSendHigh_BitfieldMask = 65535;
    private static final int kI2CConfig_DataToSendHigh_BitfieldOffset = 0;
    private static final int kDIO0_I2CConfig_Address = 33552;
    private static final int kDIO1_I2CConfig_Address = 33452;
    private static final int[] kI2CConfig_Addresses = new int[]{33552, 33452};
    private static final int kDIO_LoopTiming_Address = 33620;
    private static final int kPWMConfig_Period_BitfieldMask = -65536;
    private static final int kPWMConfig_Period_BitfieldOffset = 16;
    private static final int kPWMConfig_MinHigh_BitfieldMask = 65535;
    private static final int kPWMConfig_MinHigh_BitfieldOffset = 0;
    private static final int kDIO_PWMConfig_Address = 33616;
    public static final int kPWMValue_NumRegisters = 10;
    private static final int kDIO0_PWMValue0_Address = 33600;
    private static final int kDIO0_PWMValue1_Address = 33596;
    private static final int kDIO0_PWMValue2_Address = 33592;
    private static final int kDIO0_PWMValue3_Address = 33588;
    private static final int kDIO0_PWMValue4_Address = 33584;
    private static final int kDIO0_PWMValue5_Address = 33580;
    private static final int kDIO0_PWMValue6_Address = 33576;
    private static final int kDIO0_PWMValue7_Address = 33572;
    private static final int kDIO0_PWMValue8_Address = 33568;
    private static final int kDIO0_PWMValue9_Address = 33564;
    private static final int kDIO1_PWMValue0_Address = 33500;
    private static final int kDIO1_PWMValue1_Address = 33496;
    private static final int kDIO1_PWMValue2_Address = 33492;
    private static final int kDIO1_PWMValue3_Address = 33488;
    private static final int kDIO1_PWMValue4_Address = 33484;
    private static final int kDIO1_PWMValue5_Address = 33480;
    private static final int kDIO1_PWMValue6_Address = 33476;
    private static final int kDIO1_PWMValue7_Address = 33472;
    private static final int kDIO1_PWMValue8_Address = 33468;
    private static final int kDIO1_PWMValue9_Address = 33464;
    private static final int[] kPWMValue_Addresses = new int[]{33600, 33596, 33592, 33588, 33584, 33580, 33576, 33572, 33568, 33564, 33500, 33496, 33492, 33488, 33484, 33480, 33476, 33472, 33468, 33464};

    public tDIO(int sys_index) {
        this.m_SystemIndex = sys_index;
        if (status.isNotFatal() && this.m_SystemIndex >= 2) {
            status.setStatus(-50003);
        }
    }

    protected void finalize() {
        super.finalize();
    }

    public int getSystemIndex() {
        return this.m_SystemIndex;
    }

    public void writeDO(int value) {
        NiRioSrv.poke32(m_DeviceHandle, kDO_Addresses[this.m_SystemIndex], value, status);
    }

    public int readDO() {
        return NiRioSrv.peek32(m_DeviceHandle, kDO_Addresses[this.m_SystemIndex], status) & 0xFFFF;
    }

    public void writeI2CDataToSend(long value) {
        NiRioSrv.poke32(m_DeviceHandle, kI2CDataToSend_Addresses[this.m_SystemIndex], (int)value, status);
    }

    public long readI2CDataToSend() {
        return (long)NiRioSrv.peek32(m_DeviceHandle, kI2CDataToSend_Addresses[this.m_SystemIndex], status) & 0xFFFFFFFFL;
    }

    public void writeFilterSelect(int bitfield_index, int value) {
        if (status.isNotFatal() && bitfield_index >= 16) {
            status.setStatus(-50003);
        }
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kFilterSelect_Addresses[this.m_SystemIndex], status);
        regValue &= ~(3 << (15 - bitfield_index) * 2);
        NiRioSrv.poke32(m_DeviceHandle, kFilterSelect_Addresses[this.m_SystemIndex], regValue |= (value & 3) << (15 - bitfield_index) * 2, status);
    }

    public byte readFilterSelect(int bitfield_index) {
        if (status.isNotFatal() && bitfield_index >= 16) {
            status.setStatus(-50003);
        }
        int arrayElementValue = NiRioSrv.peek32(m_DeviceHandle, kFilterSelect_Addresses[this.m_SystemIndex], status) >>> (15 - bitfield_index) * 2 & 3;
        return (byte)(arrayElementValue & 3);
    }

    public void writeFilterPeriod(int bitfield_index, int value) {
        if (status.isNotFatal() && bitfield_index >= 3) {
            status.setStatus(-50003);
        }
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kFilterPeriod_Addresses[this.m_SystemIndex], status);
        regValue &= ~(255 << (2 - bitfield_index) * 8);
        NiRioSrv.poke32(m_DeviceHandle, kFilterPeriod_Addresses[this.m_SystemIndex], regValue |= (value & 0xFF) << (2 - bitfield_index) * 8, status);
    }

    public short readFilterPeriod(int bitfield_index) {
        if (status.isNotFatal() && bitfield_index >= 3) {
            status.setStatus(-50003);
        }
        int arrayElementValue = NiRioSrv.peek32(m_DeviceHandle, kFilterPeriod_Addresses[this.m_SystemIndex], status) >>> (2 - bitfield_index) * 8 & 0xFF;
        return (short)(arrayElementValue & 0xFF);
    }

    public void writeOutputEnable(int value) {
        NiRioSrv.poke32(m_DeviceHandle, kOutputEnable_Addresses[this.m_SystemIndex], value, status);
    }

    public int readOutputEnable() {
        return NiRioSrv.peek32(m_DeviceHandle, kOutputEnable_Addresses[this.m_SystemIndex], status) & 0xFFFF;
    }

    public int readDI() {
        return NiRioSrv.peek32(m_DeviceHandle, kDI_Addresses[this.m_SystemIndex], status) & 0xFFFF;
    }

    public long readI2CDataReceived() {
        return (long)NiRioSrv.peek32(m_DeviceHandle, kI2CDataReceived_Addresses[this.m_SystemIndex], status) & 0xFFFFFFFFL;
    }

    public int readI2CStatus() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CStatus_Addresses[this.m_SystemIndex], status);
        return regValue;
    }

    public byte readI2CStatus_Transaction() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CStatus_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x4000000) >>> 26;
        return (byte)(bitfieldValue & 1);
    }

    public boolean readI2CStatus_Done() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CStatus_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x2000000) >>> 25;
        return bitfieldValue != 0;
    }

    public boolean readI2CStatus_Aborted() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CStatus_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x1000000) >>> 24;
        return bitfieldValue != 0;
    }

    public int readI2CStatus_DataReceivedHigh() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CStatus_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xFFFFFF) >>> 0;
        return bitfieldValue & 0xFFFFFF;
    }

    public void writeSlowValue(int value) {
        NiRioSrv.poke32(m_DeviceHandle, kSlowValue_Addresses[this.m_SystemIndex], value, status);
    }

    public void writeSlowValue_RelayFwd(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kSlowValue_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFF00FFF;
        NiRioSrv.poke32(m_DeviceHandle, kSlowValue_Addresses[this.m_SystemIndex], regValue |= value << 12 & 0xFF000, status);
    }

    public void writeSlowValue_RelayRev(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kSlowValue_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFF00F;
        NiRioSrv.poke32(m_DeviceHandle, kSlowValue_Addresses[this.m_SystemIndex], regValue |= value << 4 & 0xFF0, status);
    }

    public void writeSlowValue_I2CHeader(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kSlowValue_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFFF0;
        NiRioSrv.poke32(m_DeviceHandle, kSlowValue_Addresses[this.m_SystemIndex], regValue |= value << 0 & 0xF, status);
    }

    public int readSlowValue() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kSlowValue_Addresses[this.m_SystemIndex], status);
        return regValue;
    }

    public short readSlowValue_RelayFwd() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kSlowValue_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xFF000) >>> 12;
        return (short)(bitfieldValue & 0xFF);
    }

    public short readSlowValue_RelayRev() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kSlowValue_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xFF0) >>> 4;
        return (short)(bitfieldValue & 0xFF);
    }

    public byte readSlowValue_I2CHeader() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kSlowValue_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xF) >>> 0;
        return (byte)(bitfieldValue & 0xF);
    }

    public void writePWMPeriodScale(int bitfield_index, int value) {
        if (status.isNotFatal() && bitfield_index >= 10) {
            status.setStatus(-50003);
        }
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kPWMPeriodScale_Addresses[this.m_SystemIndex], status);
        regValue &= ~(3 << (9 - bitfield_index) * 2);
        NiRioSrv.poke32(m_DeviceHandle, kPWMPeriodScale_Addresses[this.m_SystemIndex], regValue |= (value & 3) << (9 - bitfield_index) * 2, status);
    }

    public byte readPWMPeriodScale(int bitfield_index) {
        if (status.isNotFatal() && bitfield_index >= 10) {
            status.setStatus(-50003);
        }
        int arrayElementValue = NiRioSrv.peek32(m_DeviceHandle, kPWMPeriodScale_Addresses[this.m_SystemIndex], status) >>> (9 - bitfield_index) * 2 & 3;
        return (byte)(arrayElementValue & 3);
    }

    public void writePulse(int value) {
        NiRioSrv.poke32(m_DeviceHandle, kPulse_Addresses[this.m_SystemIndex], value, status);
    }

    public int readPulse() {
        return NiRioSrv.peek32(m_DeviceHandle, kPulse_Addresses[this.m_SystemIndex], status) & 0xFFFF;
    }

    public void strobeI2CStart() {
        NiRioSrv.poke32(m_DeviceHandle, kI2CStart_Addresses[this.m_SystemIndex], 1, status);
    }

    public void writeBFL(boolean value) {
        NiRioSrv.poke32(m_DeviceHandle, kBFL_Addresses[this.m_SystemIndex], value ? 1 : 0, status);
    }

    public boolean readBFL() {
        return NiRioSrv.peek32(m_DeviceHandle, kBFL_Addresses[this.m_SystemIndex], status) != 0;
    }

    public void writePulseLength(int value) {
        NiRioSrv.poke32(m_DeviceHandle, kPulseLength_Addresses[this.m_SystemIndex], value, status);
    }

    public short readPulseLength() {
        return (short)(NiRioSrv.peek32(m_DeviceHandle, kPulseLength_Addresses[this.m_SystemIndex], status) & 0xFF);
    }

    public void writeI2CConfig(int value) {
        NiRioSrv.poke32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], value, status);
    }

    public void writeI2CConfig_Address(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xC03FFFFF;
        NiRioSrv.poke32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], regValue |= value << 22 & 0x3FC00000, status);
    }

    public void writeI2CConfig_BytesToRead(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFC7FFFF;
        NiRioSrv.poke32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], regValue |= value << 19 & 0x380000, status);
    }

    public void writeI2CConfig_BytesToWrite(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFF8FFFF;
        NiRioSrv.poke32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], regValue |= value << 16 & 0x70000, status);
    }

    public void writeI2CConfig_DataToSendHigh(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFF0000;
        NiRioSrv.poke32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], regValue |= value << 0 & 0xFFFF, status);
    }

    public int readI2CConfig() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], status);
        return regValue;
    }

    public short readI2CConfig_Address() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x3FC00000) >>> 22;
        return (short)(bitfieldValue & 0xFF);
    }

    public byte readI2CConfig_BytesToRead() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x380000) >>> 19;
        return (byte)(bitfieldValue & 7);
    }

    public byte readI2CConfig_BytesToWrite() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x70000) >>> 16;
        return (byte)(bitfieldValue & 7);
    }

    public int readI2CConfig_DataToSendHigh() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xFFFF) >>> 0;
        return bitfieldValue & 0xFFFF;
    }

    public static int readLoopTiming() {
        return NiRioSrv.peek32(m_DeviceHandle, 33620, status) & 0xFFFF;
    }

    public static void writePWMConfig(int value) {
        NiRioSrv.poke32(m_DeviceHandle, 33616, value, status);
    }

    public static void writePWMConfig_Period(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, 33616, status);
        regValue &= 0xFFFF;
        NiRioSrv.poke32(m_DeviceHandle, 33616, regValue |= value << 16 & 0xFFFF0000, status);
    }

    public static void writePWMConfig_MinHigh(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, 33616, status);
        regValue &= 0xFFFF0000;
        NiRioSrv.poke32(m_DeviceHandle, 33616, regValue |= value << 0 & 0xFFFF, status);
    }

    public static int readPWMConfig() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, 33616, status);
        return regValue;
    }

    public static int readPWMConfig_Period() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, 33616, status);
        int bitfieldValue = (regValue & 0xFFFF0000) >>> 16;
        return bitfieldValue & 0xFFFF;
    }

    public static int readPWMConfig_MinHigh() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, 33616, status);
        int bitfieldValue = (regValue & 0xFFFF) >>> 0;
        return bitfieldValue & 0xFFFF;
    }

    public void writePWMValue(int reg_index, int value) {
        if (status.isNotFatal() && reg_index >= 10) {
            status.setStatus(-50003);
        }
        NiRioSrv.poke32(m_DeviceHandle, kPWMValue_Addresses[this.m_SystemIndex * 10 + reg_index], value, status);
    }

    public short readPWMValue(int reg_index) {
        if (status.isNotFatal() && reg_index >= 10) {
            status.setStatus(-50003);
        }
        return (short)(NiRioSrv.peek32(m_DeviceHandle, kPWMValue_Addresses[this.m_SystemIndex * 10 + reg_index], status) & 0xFF);
    }
}

