/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.fpga;

import com.ni.rio.NiRioSrv;
import com.ni.rio.NiRioStatus;
import edu.wpi.first.wpilibj.communication.BumARioHandle;
import edu.wpi.first.wpilibj.fpga.DMAChannelDescriptors;
import edu.wpi.first.wpilibj.fpga.ExpectedFPGASignature;

public abstract class tSystem
implements ExpectedFPGASignature,
DMAChannelDescriptors {
    protected static int m_DeviceHandle = 0;
    private static int m_ReferenceCount = 0;
    public static NiRioStatus status = new NiRioStatus();
    private static final String kRIO_DEVICE_NAME = "RIO0";
    private static final int kFPGA_RESET_REGISTER = 33026;
    private static final int kFPGA_COMMAND_REGISTER = 33028;
    private static final int kFPGA_COMMAND_ENABLE_CLEAR = 4;
    private static final int kFPGA_COMMAND_ENABLE_IN = 2;
    private static final int kFPGA_INTERRUPT_BASE_ADDRESS = 32768;
    private static final int kFPGA_SIGNATURE_REGISTER = 33032;
    private static final int kMITE_IOPCR_REGISTER = 1136;
    private static final int kMITE_IOPCR_32BIT = 12583473;

    protected tSystem() {
        NiRioStatus versionStatus = new NiRioStatus();
        if (m_DeviceHandle == 0) {
            m_DeviceHandle = BumARioHandle.bum(status.getPointer());
            int[] hwGUID = new int[4];
            for (int i = 0; i < 4; ++i) {
                NiRioStatus cleanStatus = new NiRioStatus();
                hwGUID[i] = NiRioSrv.peek32(m_DeviceHandle, 33032, cleanStatus);
                status.setStatus(cleanStatus);
                if (hwGUID[i] == ExpectedFPGASignature.kExpectedFPGASignature[i]) continue;
                versionStatus.setStatus(-63194);
            }
            System.out.print("FPGA Hardware GUID: ");
            tSystem.printGUID(hwGUID);
            System.out.println("");
            System.out.print("FPGA Software GUID: ");
            tSystem.printGUID(ExpectedFPGASignature.kExpectedFPGASignature);
            System.out.println("");
        }
        status.setStatus(versionStatus);
    }

    private static void printGUID(int[] guid) {
        System.out.print("0x");
        for (int i = 0; i < 4; ++i) {
            long longVar = guid[i];
            String word = Long.toString(longVar & 0xFFFFFFFFL, 16);
            while (word.length() < 8) {
                word = "0" + word;
            }
            System.out.print(word);
        }
    }

    protected void finalize() {
    }

    public int[] getFpgaGuid(NiRioStatus status) {
        int[] guid = new int[]{0, 0, 0, 0};
        if (m_DeviceHandle == 0) {
            status.setStatus(-63195);
            return guid;
        }
        for (int i = 0; i < 4; ++i) {
            guid[i] = NiRioSrv.peek32(m_DeviceHandle, 33032, status);
        }
        return guid;
    }

    public void Release() {
    }
}

