/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.image;

import com.sun.cldc.jna.Pointer;
import com.sun.cldc.jna.Structure;

public class EllipseMatch {
    static final int ellipseMatchSize = 40;
    public double m_xPos;
    public double m_yPos;
    public double m_rotation;
    public double m_majorRadius;
    public double m_minorRadius;
    public double m_score;

    EllipseMatch(int address) {
        new EllipseMatchStructure(address);
    }

    public String toString() {
        return "Ellipse Match:\n  Pos x: " + this.m_xPos + "  y: " + this.m_yPos + "\n" + "  Radius major: " + this.m_majorRadius + " minor: " + this.m_minorRadius + "\n" + "  Rotation: " + this.m_rotation + " Score: " + this.m_score + "\n";
    }

    protected static EllipseMatch[] getMatchesFromMemory(int address, int number) {
        if (address == 0) {
            return new EllipseMatch[0];
        }
        EllipseMatch[] toReturn = new EllipseMatch[number];
        for (int i = 0; i < number; ++i) {
            toReturn[i] = new EllipseMatch(address + i * 40);
        }
        return toReturn;
    }

    private class EllipseMatchStructure
    extends Structure {
        public EllipseMatchStructure(int address) {
            this.useMemory(new Pointer((long)address, 40));
            this.read();
        }

        public void read() {
            EllipseMatch.this.m_xPos = this.backingNativeMemory.getFloat(0L);
            EllipseMatch.this.m_yPos = this.backingNativeMemory.getFloat(4L);
            EllipseMatch.this.m_rotation = this.backingNativeMemory.getDouble(8L);
            EllipseMatch.this.m_majorRadius = this.backingNativeMemory.getDouble(16L);
            EllipseMatch.this.m_minorRadius = this.backingNativeMemory.getDouble(24L);
            EllipseMatch.this.m_score = this.backingNativeMemory.getDouble(32L);
        }

        public void write() {
        }

        public int size() {
            return 40;
        }
    }
}

