/*
 *  GLUTDebugWindow.cpp
 *  CppBot
 *
 *  Created by Alex on 2/2/10.
 *  Copyright 2010 __MyCompanyName__. All rights reserved.
 *
 */

#include "GLUTDebugWindow.h"

#include "RobotBase.h"

#include "SimInterface.h"

void GLUTDebugWindow::DisplayCallBack
    ( void )
{
    /*
     *  Local variables
     */
    char buf[ 100 ];
    unsigned int l = 0;                 // current line number

    /*
     *  Clear screen
     */
    glClear( GL_COLOR_BUFFER_BIT );
    
    /*
     * Print current mode
     */
    switch( RobotBase::p_robot->GetMode( ) )
    {
        case ROB_MODE_DISABLED:
            _snprintf( buf, sizeof( buf ), "DISABLED" );
            break;
        case ROB_MODE_AUTO:
            _snprintf( buf, sizeof( buf ), "AUTO" );
            break;
        case ROB_MODE_TELEOP:
            _snprintf( buf, sizeof( buf ), "TELEOP" );
            break;
    }
    DrawText( 0.0, (l++)*TEXT_HEIGHT, buf );

    /*
     * Draw PWM values
     */
    l++;
    for( int i = 0; i < SimInterface::PWM_CNT; i++ )
        {
        float pwm = SimInterface::GetPWM( i );
        if( pwm < -0.001 )
            {
            glColor3f( 1.0f, 0.0f, 0.0f );
            }
        else if( pwm < 0.001 )
            {
            glColor3f( 1.0f, 1.0f, 1.0f );
            }
        else
            {
            glColor3f( 0.0f, 1.0f, 0.0f );
            }
        _snprintf( buf, sizeof( buf ), "PWM[%d]: %+3.1f", i, pwm );
        DrawText( 0.0, (l++)*TEXT_HEIGHT, buf );
        }
        
    /*
     * Draw joystick button values
     */
    l++;                                // insert blank line
    for( int i = 0; i <= 10; i++ )
        {
        bool button = SimInterface::GetJoystickButton( 0, i ) || SimInterface::GetJoystickButton( 1, i ) | SimInterface::GetJoystickButton( 2, i );
        glColor3f( ( float )!button, 1.0f, ( float )!button );
        _snprintf( buf, sizeof( buf ), "JB[%d]: %d", i, button );
        DrawText( 0.0, (l++)*TEXT_HEIGHT, buf );
        }
        
    /*
     * Draw digital inputs (limit switches)
     */
    l++;                                // insert blank line
    for( int i = 0; i < SimInterface::DIO_CNT; i++ )
        {
        bool value = SimInterface::GetDIO(i);
        glColor3f( ( float )!value, 1.0f, ( float )!value );
        _snprintf( buf, sizeof( buf ), "DI[%d]: %d", i, value );
        DrawText( 0.0, (l++)*TEXT_HEIGHT, buf );
        }

    /*
     * Swap buffers to update display
     */
    glutSwapBuffers();
}