/*
 *  GLUTFieldWindow.cpp
 *  CppBot
 *
 *  Created by Alex on 1/31/10.
 *  Copyright 2010 __MyCompanyName__. All rights reserved.
 *
 */

#include <stdio.h>
#include <stdlib.h>

#include "GLUT/glut.h"
#include "GLUTFieldWindow.h"
#include "GLUTInterface.h"

#include "SimInterface.h"

#include "rob_pub.h"

int GLUTFieldWindow::m_joy_x = 0;
int GLUTFieldWindow::m_joy_y = 0;

/**************************************************************************
* DisplayCallBack
**************************************************************************/
void GLUTFieldWindow::DisplayCallBack( void )
{
    char                text[ 64 ]; // text buffer

    // Clear screen
    glClear( GL_COLOR_BUFFER_BIT );

    // Load identity matrix
    glMatrixMode( GL_MODELVIEW );
    glLoadIdentity();

    //Draw grid
    glLineWidth( 1.0f );
    
    for( int i = ( window_w % 100 ) / 2; i < window_w; i += 100 )
    {
        glBegin( GL_LINES );
            glColor3f( 0.3f, 0.3f, 0.3f );
            glVertex2f( ( float )i, 0 );
            glVertex2f( ( float )i,  window_h );
        glEnd();
    }
    
    for( int i = ( window_h % 100 ) / 2; i < window_h; i += 100 )
    {
        glBegin( GL_LINES );
            glColor3f( 0.3f, 0.3f, 0.3f );
            glVertex2f( 0,        ( float )i );
            glVertex2f( window_w, ( float )i );
        glEnd();
    }

    //Draw joystick box
    glBegin( GL_QUADS );
        glColor3f( 0.5f, 0.5f, 0.5f );
        glVertex2f( JOY_BOX_CENTER_X - JOY_BOX_RADIUS, JOY_BOX_CENTER_Y - JOY_BOX_RADIUS  );
        glVertex2f( JOY_BOX_CENTER_X - JOY_BOX_RADIUS, JOY_BOX_CENTER_Y + JOY_BOX_RADIUS  );
        glVertex2f( JOY_BOX_CENTER_X + JOY_BOX_RADIUS, JOY_BOX_CENTER_Y + JOY_BOX_RADIUS  );
        glVertex2f( JOY_BOX_CENTER_X + JOY_BOX_RADIUS, JOY_BOX_CENTER_Y - JOY_BOX_RADIUS  );
    glEnd();
    glBegin( GL_LINES );
        glColor3f( 0.0f, 0.0f, 0.0f );
        glVertex2f( JOY_BOX_CENTER_X - CROSS_HAIR_RADIUS, JOY_BOX_CENTER_Y );
        glVertex2f( JOY_BOX_CENTER_X + CROSS_HAIR_RADIUS, JOY_BOX_CENTER_Y );
        glVertex2f( JOY_BOX_CENTER_X, JOY_BOX_CENTER_Y - CROSS_HAIR_RADIUS );
        glVertex2f( JOY_BOX_CENTER_X, JOY_BOX_CENTER_Y + CROSS_HAIR_RADIUS );
    glEnd();
    glBegin( GL_QUADS );
        glColor3f( 1.0f, 1.0f, 1.0f );
        glVertex2f( ( float )( m_joy_x - 2 ), ( float )( m_joy_y - 2 ) );
        glVertex2f( ( float )( m_joy_x + 2 ), ( float )( m_joy_y - 2 ) );
        glVertex2f( ( float )( m_joy_x + 2 ), ( float )( m_joy_y + 2 ) );
        glVertex2f( ( float )( m_joy_x - 2 ), ( float )( m_joy_y + 2 ) );
    glEnd();

    //Draw motor bars
    int                 lt;
    int                 rt;
    rob_get_motors( &rt, &lt );    //expect +/- 100
    draw_motor_bar( rt, MOTOR_BAR_RIGHT );
    draw_motor_bar( lt, MOTOR_BAR_LEFT );

    //Draw position and time text
    float               hdg, x, y;
    rob_get_pos( &hdg, &x, &y );
    glColor3f( 1.0f, 1.0f, 1.0f );
    _snprintf( text, sizeof( text ), "x=%.2f y=%.2f hdng=%.2f", x, y, hdg );
    DrawText( 10, 10, text );
    _snprintf( text, sizeof( text ), "t=%.3f", ( float )GLUTInterface::time_ms / 1000.0f );
    DrawText( 10, 20, text );

    // Move coordinate system to the center of the screen and point the y-axis up
    glTranslatef( window_w / 2, window_h / 2, 0.0f );
    glScalef( 1.0f, -1.0f, 1.0f );  // point y-axis up

    //Draw bot
    glPushMatrix( );
        // Switch to the robot body coordinate system
        glTranslatef( x, y, 0.0f );
        glRotatef( hdg, 0.0f, 0.0f, -1.0f );

        glLineWidth( 2.0f );
        glBegin( GL_LINES );
            glColor3f( 1.0f, 1.0f, 1.0f );
            glVertex2f( -5.0f, -10.0f );
            glVertex2f( 5.0f, -10.0f );

            glVertex2f( 5.0f, -10.0f );
            glVertex2f( 5.0f, 10.0f );

            glVertex2f( -5.0f, 10.0f );
            glVertex2f( -5.0f, -10.0f );

            glColor3f( 1.0f, 0.0f, 0.0f );
            glVertex2f( 5.0f, 10.0f );
            glVertex2f( -5.0f, 10.0f );

        glEnd();
    glPopMatrix( );

    // Draw guide line (for the line following code)
    // Note that line position is hard-coded here to be along the Y-axis
    // This must match the code in TBD
    // TODO: make this parameterized
    glLineWidth( 2.5f );
    glBegin( GL_LINES );
        glColor3f( 0.1f, 0.1f, 1.0f );
        glVertex2f( 0, 0 );
        glVertex2f( 0, HEIGHT / 2 );
    glEnd();

//Draw objects
#if 0   //TODO
glPushMatrix( );
    {
    for( i = 0; i < field_obj_ct; i++ )
        {
        glColor3f( obj[ i ].r, obj[ i ].g, obj[ i ].b );
        glBegin( GL_POLYGON );
            {
            for( j = 0; j < obj[ i ].ct; j++ )
                {
                    glVertex2f( obj[ i ].xy[ j ].x, obj[ i ].xy[ j ].y );
                }
            }
        glEnd();
        }
    }
glPopMatrix( );
#endif

/*----------------------------------------------------------
Swap buffers to update display
----------------------------------------------------------*/
glutSwapBuffers();
}   /* GLUTFieldWindow::DisplayCallBack */


/**************************************************************************
* ReshapeCallBack - This function is called when the window is reshaped
**************************************************************************/
void GLUTFieldWindow::ReshapeCallBack
    (
    int                 x,          /* new x dimension              */
    int                 y           /* new y demension              */
    )
{
#if 0   //TODO
joy_x1 = JOY_W / -2;
joy_x2 = JOY_W / 2;
joy_y2 = y / 2;
joy_y1 = joy_y2 - JOY_H;
#endif

GLUTWindow::ReshapeCallBack( x, y );
}   /* GLUTFieldWindow::ReshapeCallBack */

/**************************************************************************
* draw_motor_bar - Draw Motor Bars
**************************************************************************/
void GLUTFieldWindow::draw_motor_bar
    ( 
    int motor_val,                  // 0..100 
    int motor_bar_x                 // in window coordinates
    )
{
    char                text[ 32 ]; // text buffer

    // Draw the motor bar
    glLineWidth( 10.0f );
    glBegin( GL_LINES );
        glColor3f( motor_val > 0.0f ? 0.0f : 1.0f, motor_val > 0.0f ? 1.0f : 0.0f, 0.0f );
        glVertex2f( motor_bar_x, HEIGHT / 2 );
        glVertex2f( motor_bar_x, HEIGHT / 2 - motor_val * MOTOR_BAR_HEIGHT / 100.0f );
    glEnd();
    
    // Print motor value
    glColor3f( 1.0f, 1.0f, 1.0f );
    _snprintf( text, sizeof( text ), "%d", motor_val );   // TODO: use 
    DrawText( motor_bar_x, HEIGHT / 2, text );
}


/**************************************************************************
* motion_cb - Glut Motion Callback Function
**************************************************************************/
void GLUTFieldWindow::motion_cb
    (
    int                 x,          /* mouse X coordinate           */
    int                 y           /* mouse Y coordinate           */
    )
{
    if( ( x >= ( JOY_BOX_CENTER_X - JOY_BOX_RADIUS ) ) && ( x <= ( JOY_BOX_CENTER_X + JOY_BOX_RADIUS ) ) )
    {
        if( ( y >= ( JOY_BOX_CENTER_Y - JOY_BOX_RADIUS ) ) && ( y <= ( JOY_BOX_CENTER_Y + JOY_BOX_RADIUS ) ) )
        {
            m_joy_x = x;
            m_joy_y = y;
        }
    }
}   /* GLUTInterface::motion_cb */


/**************************************************************************
* mouse_cb - Glut Mouse Callback Function
**************************************************************************/
void GLUTFieldWindow::mouse_cb
    (
    int                 button,     /* mouse button                 */
    int                 state,      /* button state                 */
    int                 x,          /* mouse X coordinate           */
    int                 y           /* mouse Y coordinate           */
    )
{
    /*----------------------------------------------------------
    Left mouse button
    ----------------------------------------------------------*/
    if( button == GLUT_LEFT_BUTTON )
        {
        /*------------------------------------------------------
        Mouse up
        ------------------------------------------------------*/
        if( state == GLUT_UP )
            {
            m_joy_x = 0;
            m_joy_y = 0;
            }

        /*------------------------------------------------------
        Mouse down
        ------------------------------------------------------*/
        else if( state == GLUT_DOWN )
            {
            motion_cb( x, y );
            }
        }

    /*----------------------------------------------------------
    Right mouse button
    ----------------------------------------------------------*/
    else if( button == GLUT_RIGHT_BUTTON )
        {
        /*------------------------------------------------------
        Mouse up
        ------------------------------------------------------*/
        if( state == GLUT_UP )
            {
            }

        /*------------------------------------------------------
        Mouse down
        ------------------------------------------------------*/
        else if( state == GLUT_DOWN )
            {
            }
        }
}   /* GLUTInterface::mouse_cb */


