/*
 *  GLUTInterface.h
 *  CppBot
 *
 *  Created by Alex on 1/31/10.
 *  Copyright 2010 __MyCompanyName__. All rights reserved.
 *
 */
 
 #include <map>
 #include "GLUTWindow.h"

class GLUTInterface
{
public:

    static unsigned int time_ms;    /* simulation millisecond counter       */  //TODO: does this belong here?
    
private:

    typedef std::map< int, GLUTWindow* > window_map_type;

    static unsigned int frame_period_ms;
                                    /* current frame period in milliseconds */
    static window_map_type window_map;     
                                    /* a list of all GLUT windows and their */
                                    /*  IDs                                 */
    static bool running;            /* is simulation running?               */


public:

    /**************************************************************************
    * Init() - Call this function at start-up
    **************************************************************************/
    static void Init( unsigned int fps, int argc, char* argv[] );
    
    /**************************************************************************
    * RegisterWindow() - Call this function every time you create a window 
    *   object
    **************************************************************************/
    static void RegisterWindow( GLUTWindow * p_window );


private:
    static void display_cb( void );
    static void idle_cb( void );
    static void joystick_cb( unsigned int buttonMask, int x, int y, int z );
    static void keyboard_cb( unsigned char key, int x, int y );
    static void reshape_cb( int x, int y );
    static void time_proc( int value );
};