/*
 *  GLUTWindow.cpp
 *  CppBot
 *
 *  Created by Alex on 1/31/10.
 *  Copyright 2010 __MyCompanyName__. All rights reserved.
 *
 */

#include <stdlib.h>
#include "CppBot_types.h"

#include "GLUT/glut.h"
#include "GLUTInterface.h"
#include "GLUTWindow.h"

#define TXT_BMP_W       ( 128 )     /* text bitmap width            */
#define TXT_BMP_H       ( 128 )     /* text bitmap height           */

typedef struct                      /* text data                    */
    {
    uint8                   x;      /* x offset in bmp for char     */
    uint8                   y;      /* y offset in bmp for char     */
    uint8                   w;      /* width in bmp for char        */
    uint8                   h;      /* height in bmp for char       */
    } text_data_t;

const uint8 text_bmp_data[] =       /*  text bitmap data            */
    {
#include "utl_draw_txt.dat"
    };

const text_data_t text_data[ 256 ] =
                                    /* text data for each character */
    {   /*  X       Y       W       H          Dec Value    Char    */
          { 0,      0,      0,      0 },    /* 0            N/A     */
          { 0,      0,      0,      0 },    /* 1            N/A     */
          { 0,      0,      0,      0 },    /* 2            N/A     */
          { 0,      0,      0,      0 },    /* 3            N/A     */
          { 0,      0,      0,      0 },    /* 4            N/A     */
          { 0,      0,      0,      0 },    /* 5            N/A     */
          { 0,      0,      0,      0 },    /* 6            N/A     */
          { 0,      0,      0,      0 },    /* 7            N/A     */
          { 0,      0,      0,      0 },    /* 8            N/A     */
          { 0,      0,      0,      0 },    /* 9            N/A     */
          { 0,      0,      0,      0 },    /* 10           N/A     */
          { 0,      0,      0,      0 },    /* 11           N/A     */
          { 0,      0,      0,      0 },    /* 12           N/A     */
          { 0,      0,      0,      0 },    /* 13           N/A     */
          { 0,      0,      0,      0 },    /* 14           N/A     */
          { 0,      0,      0,      0 },    /* 15           N/A     */
          { 0,      0,      0,      0 },    /* 16           N/A     */
          { 0,      0,      0,      0 },    /* 17           N/A     */
          { 0,      0,      0,      0 },    /* 18           N/A     */
          { 0,      0,      0,      0 },    /* 19           N/A     */
          { 0,      0,      0,      0 },    /* 20           N/A     */
          { 0,      0,      0,      0 },    /* 21           N/A     */
          { 0,      0,      0,      0 },    /* 22           N/A     */
          { 0,      0,      0,      0 },    /* 23           N/A     */
          { 0,      0,      0,      0 },    /* 24           N/A     */
          { 0,      0,      0,      0 },    /* 25           N/A     */
          { 0,      0,      0,      0 },    /* 26           N/A     */
          { 0,      0,      0,      0 },    /* 27           N/A     */
          { 0,      0,      0,      0 },    /* 28           N/A     */
          { 0,      0,      0,      0 },    /* 29           N/A     */
          { 0,      0,      0,      0 },    /* 30           N/A     */
          { 0,      0,      0,      0 },    /* 31           N/A     */
          { 0,      0,      8,     10 },    /* 32           space   */
          { 8,      0,      8,     10 },    /* 33           !       */
          { 16,     0,      8,     10 },    /* 34           "       */
          { 24,     0,      8,     10 },    /* 35           #       */
          { 32,     0,      8,     10 },    /* 36           $       */
          { 40,     0,      8,     10 },    /* 37           %       */
          { 48,     0,      8,     10 },    /* 38           &       */
          { 56,     0,      8,     10 },    /* 39           '       */
          { 64,     0,      8,     10 },    /* 40           (       */
          { 72,     0,      8,     10 },    /* 41           )       */
          { 80,     0,      8,     10 },    /* 42           *       */
          { 88,     0,      8,     10 },    /* 43           +       */
          { 96,     0,      8,     10 },    /* 44           ,       */
          { 104,    0,      8,     10 },    /* 45           -       */
          { 112,    0,      8,     10 },    /* 46           .       */
          { 120,    0,      8,     10 },    /* 47           /       */
          { 0,      16,     8,     10 },    /* 48           0       */
          { 8,      16,     8,     10 },    /* 49           1       */
          { 16,     16,     8,     10 },    /* 50           2       */
          { 24,     16,     8,     10 },    /* 51           3       */
          { 32,     16,     8,     10 },    /* 52           4       */
          { 40,     16,     8,     10 },    /* 53           5       */
          { 48,     16,     8,     10 },    /* 54           6       */
          { 56,     16,     8,     10 },    /* 55           7       */
          { 64,     16,     8,     10 },    /* 56           8       */
          { 72,     16,     8,     10 },    /* 57           10       */
          { 80,     16,     8,     10 },    /* 58           :       */
          { 88,     16,     8,     10 },    /* 59           ;       */
          { 96,     16,     8,     10 },    /* 60           <       */
          { 104,    16,     8,     10 },    /* 61           =       */
          { 112,    16,     8,     10 },    /* 62           >       */
          { 120,    16,     8,     10 },    /* 63           ?       */
          { 0,      32,     8,     10 },    /* 64           @       */
          { 8,      32,     8,     10 },    /* 65           A       */
          { 16,     32,     8,     10 },    /* 66           B       */
          { 24,     32,     8,     10 },    /* 67           C       */
          { 32,     32,     8,     10 },    /* 68           D       */
          { 40,     32,     8,     10 },    /* 69           E       */
          { 48,     32,     8,     10 },    /* 70           F       */
          { 56,     32,     8,     10 },    /* 71           G       */
          { 64,     32,     8,     10 },    /* 72           H       */
          { 72,     32,     8,     10 },    /* 73           I       */
          { 80,     32,     8,     10 },    /* 74           J       */
          { 88,     32,     8,     10 },    /* 75           K       */
          { 96,     32,     8,     10 },    /* 76           L       */
          { 104,    32,     8,     10 },    /* 77           M       */
          { 112,    32,     8,     10 },    /* 78           N       */
          { 120,    32,     8,     10 },    /* 79           O       */
          { 0,      48,     8,     10 },    /* 80           P       */
          { 8,      48,     8,     10 },    /* 81           Q       */
          { 16,     48,     8,     10 },    /* 82           R       */
          { 24,     48,     8,     10 },    /* 83           S       */
          { 32,     48,     8,     10 },    /* 84           T       */
          { 40,     48,     8,     10 },    /* 85           U       */
          { 48,     48,     8,     10 },    /* 86           V       */
          { 56,     48,     8,     10 },    /* 87           W       */
          { 64,     48,     8,     10 },    /* 88           X       */
          { 72,     48,     8,     10 },    /* 89           Y       */
          { 80,     48,     8,     10 },    /* 90           Z       */
          { 88,     48,     8,     10 },    /* 91           [       */
          { 96,     48,     8,     10 },    /* 92           \       */
          { 104,    48,     8,     10 },    /* 93           ]       */
          { 112,    48,     8,     10 },    /* 94           ^       */
          { 120,    48,     8,     10 },    /* 95           _       */
          { 0,      64,     8,     10 },    /* 96           `       */
          { 8,      64,     8,     10 },    /* 97           a       */
          { 16,     64,     8,     10 },    /* 98           b       */
          { 24,     64,     8,     10 },    /* 99           c       */
          { 32,     64,     8,     10 },    /* 100          d       */
          { 40,     64,     8,     10 },    /* 101          e       */
          { 48,     64,     8,     10 },    /* 102          f       */
          { 56,     64,     8,     12 },    /* 103          g       */
          { 64,     64,     8,     10 },    /* 104          h       */
          { 72,     64,     8,     10 },    /* 105          i       */
          { 80,     64,     8,     12 },    /* 106          j       */
          { 88,     64,     8,     10 },    /* 107          k       */
          { 96,     64,     8,     10 },    /* 108          l       */
          { 104,    64,     8,     10 },    /* 109          m       */
          { 112,    64,     8,     10 },    /* 110          n       */
          { 120,    64,     8,     10 },    /* 111          o       */
          { 0,      80,     8,     12 },    /* 112          p       */
          { 8,      80,     8,     12 },    /* 113          q       */
          { 16,     80,     8,     10 },    /* 114          r       */
          { 24,     80,     8,     10 },    /* 115          s       */
          { 32,     80,     8,     10 },    /* 116          t       */
          { 40,     80,     8,     10 },    /* 117          u       */
          { 48,     80,     8,     10 },    /* 118          v       */
          { 56,     80,     8,     10 },    /* 119          w       */
          { 64,     80,     8,     10 },    /* 120          x       */
          { 72,     80,     8,     12 },    /* 121          y       */
          { 80,     80,     8,     10 },    /* 122          z       */
          { 88,     80,     8,     10 },    /* 123          {       */
          { 96,     80,     8,     10 },    /* 124          |       */
          { 104,    80,     8,     10 },    /* 125          }       */
          { 112,    80,     8,     10 },    /* 126          ~       */
          { 0,      0,      0,      0 },    /* 127          N/A     */
          { 0,      0,      0,      0 },    /* 128          N/A     */
          { 0,      0,      0,      0 },    /* 129          N/A     */
          { 0,      0,      0,      0 },    /* 130          N/A     */
          { 0,      0,      0,      0 },    /* 131          N/A     */
          { 0,      0,      0,      0 },    /* 132          N/A     */
          { 0,      0,      0,      0 },    /* 133          N/A     */
          { 0,      0,      0,      0 },    /* 134          N/A     */
          { 0,      0,      0,      0 },    /* 135          N/A     */
          { 0,      0,      0,      0 },    /* 136          N/A     */
          { 0,      0,      0,      0 },    /* 137          N/A     */
          { 0,      0,      0,      0 },    /* 138          N/A     */
          { 0,      0,      0,      0 },    /* 139          N/A     */
          { 0,      0,      0,      0 },    /* 140          N/A     */
          { 0,      0,      0,      0 },    /* 141          N/A     */
          { 0,      0,      0,      0 },    /* 142          N/A     */
          { 0,      0,      0,      0 },    /* 143          N/A     */
          { 0,      0,      0,      0 },    /* 144          N/A     */
          { 0,      0,      0,      0 },    /* 145          N/A     */
          { 0,      0,      0,      0 },    /* 146          N/A     */
          { 0,      0,      0,      0 },    /* 147          N/A     */
          { 0,      0,      0,      0 },    /* 148          N/A     */
          { 0,      0,      0,      0 },    /* 149          N/A     */
          { 0,      0,      0,      0 },    /* 150          N/A     */
          { 0,      0,      0,      0 },    /* 151          N/A     */
          { 0,      0,      0,      0 },    /* 152          N/A     */
          { 0,      0,      0,      0 },    /* 153          N/A     */
          { 0,      0,      0,      0 },    /* 154          N/A     */
          { 0,      0,      0,      0 },    /* 155          N/A     */
          { 0,      0,      0,      0 },    /* 156          N/A     */
          { 0,      0,      0,      0 },    /* 157          N/A     */
          { 0,      0,      0,      0 },    /* 158          N/A     */
          { 0,      0,      0,      0 },    /* 159          N/A     */
          { 0,      0,      0,      0 },    /* 160          N/A     */
          { 0,      0,      0,      0 },    /* 161          N/A     */
          { 0,      0,      0,      0 },    /* 162          N/A     */
          { 0,      0,      0,      0 },    /* 163          N/A     */
          { 0,      0,      0,      0 },    /* 164          N/A     */
          { 0,      0,      0,      0 },    /* 165          N/A     */
          { 0,      0,      0,      0 },    /* 166          N/A     */
          { 0,      0,      0,      0 },    /* 167          N/A     */
          { 0,      0,      0,      0 },    /* 168          N/A     */
          { 0,      0,      0,      0 },    /* 169          N/A     */
          { 0,      0,      0,      0 },    /* 170          N/A     */
          { 0,      0,      0,      0 },    /* 171          N/A     */
          { 0,      0,      0,      0 },    /* 172          N/A     */
          { 0,      0,      0,      0 },    /* 173          N/A     */
          { 0,      0,      0,      0 },    /* 174          N/A     */
          { 0,      0,      0,      0 },    /* 175          N/A     */
          { 0,      0,      0,      0 },    /* 176          N/A     */
          { 0,      0,      0,      0 },    /* 177          N/A     */
          { 0,      0,      0,      0 },    /* 178          N/A     */
          { 0,      0,      0,      0 },    /* 179          N/A     */
          { 0,      0,      0,      0 },    /* 180          N/A     */
          { 0,      0,      0,      0 },    /* 181          N/A     */
          { 0,      0,      0,      0 },    /* 182          N/A     */
          { 0,      0,      0,      0 },    /* 183          N/A     */
          { 0,      0,      0,      0 },    /* 184          N/A     */
          { 0,      0,      0,      0 },    /* 185          N/A     */
          { 0,      0,      0,      0 },    /* 186          N/A     */
          { 0,      0,      0,      0 },    /* 187          N/A     */
          { 0,      0,      0,      0 },    /* 188          N/A     */
          { 0,      0,      0,      0 },    /* 189          N/A     */
          { 0,      0,      0,      0 },    /* 190          N/A     */
          { 0,      0,      0,      0 },    /* 191          N/A     */
          { 0,      0,      0,      0 },    /* 192          N/A     */
          { 0,      0,      0,      0 },    /* 193          N/A     */
          { 0,      0,      0,      0 },    /* 194          N/A     */
          { 0,      0,      0,      0 },    /* 195          N/A     */
          { 0,      0,      0,      0 },    /* 196          N/A     */
          { 0,      0,      0,      0 },    /* 197          N/A     */
          { 0,      0,      0,      0 },    /* 198          N/A     */
          { 0,      0,      0,      0 },    /* 199          N/A     */
          { 0,      0,      0,      0 },    /* 200          N/A     */
          { 0,      0,      0,      0 },    /* 201          N/A     */
          { 0,      0,      0,      0 },    /* 202          N/A     */
          { 0,      0,      0,      0 },    /* 203          N/A     */
          { 0,      0,      0,      0 },    /* 204          N/A     */
          { 0,      0,      0,      0 },    /* 205          N/A     */
          { 0,      0,      0,      0 },    /* 206          N/A     */
          { 0,      0,      0,      0 },    /* 207          N/A     */
          { 0,      0,      0,      0 },    /* 208          N/A     */
          { 0,      0,      0,      0 },    /* 209          N/A     */
          { 0,      0,      0,      0 },    /* 210          N/A     */
          { 0,      0,      0,      0 },    /* 211          N/A     */
          { 0,      0,      0,      0 },    /* 212          N/A     */
          { 0,      0,      0,      0 },    /* 213          N/A     */
          { 0,      0,      0,      0 },    /* 214          N/A     */
          { 0,      0,      0,      0 },    /* 215          N/A     */
          { 0,      0,      0,      0 },    /* 216          N/A     */
          { 0,      0,      0,      0 },    /* 217          N/A     */
          { 0,      0,      0,      0 },    /* 218          N/A     */
          { 0,      0,      0,      0 },    /* 219          N/A     */
          { 0,      0,      0,      0 },    /* 220          N/A     */
          { 0,      0,      0,      0 },    /* 221          N/A     */
          { 0,      0,      0,      0 },    /* 222          N/A     */
          { 0,      0,      0,      0 },    /* 223          N/A     */
          { 0,      0,      0,      0 },    /* 224          N/A     */
          { 0,      0,      0,      0 },    /* 225          N/A     */
          { 0,      0,      0,      0 },    /* 226          N/A     */
          { 0,      0,      0,      0 },    /* 227          N/A     */
          { 0,      0,      0,      0 },    /* 228          N/A     */
          { 0,      0,      0,      0 },    /* 229          N/A     */
          { 0,      0,      0,      0 },    /* 230          N/A     */
          { 0,      0,      0,      0 },    /* 231          N/A     */
          { 0,      0,      0,      0 },    /* 232          N/A     */
          { 0,      0,      0,      0 },    /* 233          N/A     */
          { 0,      0,      0,      0 },    /* 234          N/A     */
          { 0,      0,      0,      0 },    /* 235          N/A     */
          { 0,      0,      0,      0 },    /* 236          N/A     */
          { 0,      0,      0,      0 },    /* 237          N/A     */
          { 0,      0,      0,      0 },    /* 238          N/A     */
          { 0,      0,      0,      0 },    /* 239          N/A     */
          { 0,      0,      0,      0 },    /* 240          N/A     */
          { 0,      0,      0,      0 },    /* 241          N/A     */
          { 0,      0,      0,      0 },    /* 242          N/A     */
          { 0,      0,      0,      0 },    /* 243          N/A     */
          { 0,      0,      0,      0 },    /* 244          N/A     */
          { 0,      0,      0,      0 },    /* 245          N/A     */
          { 0,      0,      0,      0 },    /* 246          N/A     */
          { 0,      0,      0,      0 },    /* 247          N/A     */
          { 0,      0,      0,      0 },    /* 248          N/A     */
          { 0,      0,      0,      0 },    /* 249          N/A     */
          { 0,      0,      0,      0 },    /* 250          N/A     */
          { 0,      0,      0,      0 },    /* 251          N/A     */
          { 0,      0,      0,      0 },    /* 252          N/A     */
          { 0,      0,      0,      0 },    /* 253          N/A     */
          { 0,      0,      0,      0 },    /* 254          N/A     */
          { 0,      0,      0,      0 }     /* 255          N/A     */
    };


/**************************************************************************
* GLUTWindow - Constructor
**************************************************************************/
GLUTWindow::GLUTWindow( const char * name, int w, int h, int x, int y ) : 
    window_w( 600 ), 
    window_h( 600 ), 
    window_x( 50 ), 
    window_y( 50 ) 
{ 
/*----------------------------------------------------------
Create window
----------------------------------------------------------*/
glutInitWindowPosition( x, y );
glutInitWindowSize( w, h );
glut_id = glutCreateWindow( name );

/*----------------------------------------------------------
Create and load texture used for drawing text
----------------------------------------------------------*/
glGenTextures( 1, texture );
glBindTexture( GL_TEXTURE_2D, texture[ 0 ] );
glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT );
glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );
glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
glTexImage2D
    (
    GL_TEXTURE_2D,
    0,
    GL_RGBA,
    TXT_BMP_W,
    TXT_BMP_H,
    0,
    GL_RGBA,
    GL_UNSIGNED_BYTE,
    text_bmp_data
    );
    
// Register window with the GLUT interface
GLUTInterface::RegisterWindow( this );
}   /* GLUTWindow::GLUTWindow */


/**************************************************************************
* DrawText - Draw text at the specified position
**************************************************************************/
void GLUTWindow::DrawText
    (
    float                   x,      /* X start point of text        */
    float                   y,      /* Y start point of text        */
    char *                  c       /* pointer to null term string  */
    )
{
/*----------------------------------------------------------
Local variables
----------------------------------------------------------*/
float                       cx;     /* x offset in bmp for char     */
float                       cy;     /* y offset in bmp for char     */
float                       cw;     /* width in bmp for char        */
float                       ch;     /* height in bmp for char       */

/*----------------------------------------------------------
Set up for textured font
----------------------------------------------------------*/
glPushAttrib( GL_ENABLE_BIT );
glEnable( GL_BLEND );
glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );
glEnable( GL_TEXTURE_2D );
glBindTexture( GL_TEXTURE_2D, texture[ 0 ] );

/*----------------------------------------------------------
Print character string
----------------------------------------------------------*/
while( *c )
    {
    cx = (float)text_data[ *c ].x;
    cy = (float)text_data[ *c ].y;
    cw = (float)text_data[ *c ].w;
    ch = (float)text_data[ *c ].h;

    glBegin( GL_TRIANGLE_FAN );
        glTexCoord2f( cx / TXT_BMP_W, cy / TXT_BMP_H );
        glVertex2f( x, y );
        glTexCoord2f( ( cx + cw ) / TXT_BMP_W, cy / TXT_BMP_H );
        glVertex2f( x + cw, y );
        glTexCoord2f( ( cx + cw ) / TXT_BMP_W, ( cy + ch ) / TXT_BMP_H );
        glVertex2f( x + cw, y + ch );
        glTexCoord2f( cx / TXT_BMP_W, ( cy + ch ) / TXT_BMP_H );
        glVertex2f( x, y + ch );
    glEnd( );

    x = x + cw;
    c++;
    }

/*----------------------------------------------------------
Restore attributes
----------------------------------------------------------*/
glPopAttrib();
}   /* GLUTWindow::DrawText */


/**************************************************************************
* ReshapeCallBack - This function is called when the window is reshaped
**************************************************************************/
void GLUTWindow::ReshapeCallBack
    (
    int                 x,          /* new x dimension              */
    int                 y           /* new y demension              */
    )
{
/*----------------------------------------------------------
Create viewport
----------------------------------------------------------*/
glViewport( 0, 0, x, y );

/*----------------------------------------------------------
Save the new width and height
----------------------------------------------------------*/
window_w = x;
window_h = y;

/*----------------------------------------------------------
Set new Orthographic viewing area
----------------------------------------------------------*/
glMatrixMode( GL_PROJECTION );
glLoadIdentity();
glOrtho( 0.0f, x, y, 0.0f, 0.0f, 1.0f );
//glScalef( ( float )x, ( float )y, 1.0f );
//glScalef( (float)x / (float)SCREEN_W, (float)y / (float)SCREEN_H, 1.0f );

/*----------------------------------------------------------
Redraw display
----------------------------------------------------------*/
glutPostRedisplay();
}   /* GLUTWindow::ReshapeCallBack */

