/*
 *  SimLimitedRotator.cpp
 *  CppBot
 *
 *  Created by Alex on 2/3/10.
 *  Copyright 2010 __MyCompanyName__. All rights reserved.
 *
 */

#include "SimInterface.h"
#include "SimLimitedRotator.h"

/*
 * SimLimitedRotator
 */
SimLimitedRotator::SimLimitedRotator
    (
    float max_angle,                // maximum arm angle
    unsigned int motor_channel,     // motor PWM channel
    unsigned int analog_channel,    // analog sensor (gyro) channel
    unsigned int min_switch_channel,// channel of the limit switch that will be 
                                    // activated when arm reaches 0
    unsigned int max_switch_channel,// channel of the limit switch that will be 
                                    //  activated when arm reaches max
    float init_pos_deg,             // Initial position
    float max_rpm,                  // Maximum rotation rate (rpm)
    float zero_to_max_s             // how many seconds it takes to go from 
                                    //  zero to full speed
    ) :
    SimRotator( motor_channel, analog_channel, max_rpm, zero_to_max_s, init_pos_deg ),
    m_max_angle( max_angle ),
    m_max_channel( max_switch_channel ),
    m_min_channel( min_switch_channel )
{
}   /* SimLimitedRotator::SimLimitedRotator */
        

/*
 * limit()
 * Limit the angle to the allowed range and return the resutl.
 * Also sets the limit switch inputs
 */
double SimLimitedRotator::limit( double angle_deg )
{
    bool limit_switch_active;

    if( angle_deg <= 0.0 )
    {
        angle_deg = 0.0;
        limit_switch_active = true;
    }
    else
    {
        limit_switch_active = false;
    }
    SimInterface::SetDIO( m_min_channel, limit_switch_active );
    
    if( angle_deg >= m_max_angle )
    {
        angle_deg = m_max_angle;
        limit_switch_active = true;
    }
    else
    {
        limit_switch_active = false;
    }
    SimInterface::SetDIO( m_max_channel, limit_switch_active );
    
    return( angle_deg );
}   /* SimLimitedRotator::limit */