/*
 *  SimLimitedRotator.h
 *  CppBot
 *
 *  Created by Alex on 2/3/10.
 *  Copyright 2010 __MyCompanyName__. All rights reserved.
 *
 */

#ifndef SIMLIMITEDROTATOR_H
#define SIMLIMITEDROTATOR_H

#include "SimRotator.h"

/*
 *  SimLimitedRotator
 *  Similar to SimRotator, but the arm position will be limited to a range 
 *  specified in the constructor.
 *  When the arm hits a limit, a corresponding limit switch (digital input) 
 *  will be activated
 */
class SimLimitedRotator : public SimRotator
{
public:
    /*
     * SimLimitedRotator
     * Constructor
     */
    SimLimitedRotator
        (
        float max_angle,            // maximum arm angle
        unsigned int motor_channel,
                                    // motor PWM channel
        unsigned int analog_channel,// analog sensor (gyro) channel
        unsigned int min_switch_channel,
                                    // channel of the limit switch that will be 
                                    // activated when arm reaches 0
        unsigned int max_switch_channel,
                                    // channel of the limit switch that will be 
                                    //  activated when arm reaches max
        float init_pos_deg = 0,     // Initial position (degrees, measured counterclockwise from the X-axis)
        float max_rpm = 60,         // Maximum rotation rate (revolutions per minute)
        float zero_to_max_s = 0.001 // how many seconds it takes to go from zero to full speed
        );
        
protected:
    float m_max_angle;              // maximum arm angle

private:
    unsigned int m_max_channel;     // channel of the limit switch that will be
                                    //  activated when arm reaches max
    unsigned int m_min_channel;     // channel of the limit switch that will be 
                                    //  activated when arm reaches 0

    virtual double limit( double angle_deg );
};

#endif  /* SIMLIMITEDROTATOR_H */