#ifndef SIMWINCHLIFT_H
#define SIMWINCHLIFT_H

#include "SimLimitedRotator.h"

class SimWinchLift : public SimLimitedRotator
{
private:
    int m_reverse;                  // -1 if winch has reversed direction

public:
    SimWinchLift
        ( 
        unsigned int motor_channel,
                                    // motor PWM channel
        //unsigned int min_switch_channel,
        //                            // channel of the limit switch that will be 
        //                            // activated when arm reaches 0
        //unsigned int max_switch_channel,
        //                            // channel of the limit switch that will be 
        //                            //  activated when arm reaches max
        unsigned int travel_time_s  // how long it takes to travel from bottom to top at full speed
        ) : SimLimitedRotator( 180.0f, motor_channel, 0, 0, 0, 0, 0.5f * ( 60.0f / travel_time_s ) ),
            m_reverse( 1 )
    {         
    }
    
private:
    virtual double get_pwm( void )
    {
        return( m_reverse * SimRotator::get_pwm() );
    }

    virtual double limit( double angle_deg )
    {
        if( angle_deg < 0 )
        {
            m_reverse = -m_reverse;
            angle_deg = -angle_deg;
        }
        else if( angle_deg > m_max_angle )
        {
            angle_deg = m_max_angle;
        }

        return( angle_deg );
    }
};

#endif  /* SIMWINCHLIFT_H */