/*********************************************************************
*
*   rob_main.cpp - Robot main module
*
*   Copyright:
*       Software source code by Alex Morozov and Chris D. Locke is
*       licensed under a Creative Commons Attribution-Noncommercial-
*       Share Alike 3.0 United States License
*       (http://creativecommons.org/licenses/by-nc-sa/3.0/us/)
*
*********************************************************************/
#include "CppBot.h"
#include "CppBot_types.h"
#include "RobotBase.h"

void rob_get_pos
    (
    float *             hdg,
    float *             x,
    float *             y
    )
{
if( RobotBase::p_robot != NULL )
    {
    RobotBase::p_robot->GetRobotPosition( x, y, hdg );
    }
}

void rob_get_motors
    (
    int *               rt,
    int *               lt
    )
{
if( RobotBase::p_robot != NULL )
    {
    RobotBase::p_robot->GetMotorSpeed( lt, rt );
    }
}


void rob_init
    ( void )
{
_ASSERT( RobotBase::p_robot != NULL );
RobotBase::p_robot->RobotInit( );
RobotBase::p_robot->DisabledInit( );
}


void rob_set_mode
    (
    rob_mode_type       mode
    )
{
_ASSERT( RobotBase::p_robot != NULL );
RobotBase::p_robot->SetMode( mode );
}
