/*----------------------------------------------------------------------------*/
/* Copyright (c) FIRST 2008. All Rights Reserved.							  */
/* Open Source Software - may be modified and shared by FRC teams. The code   */
/* must be accompanied by the FIRST BSD license file in $(WIND_BASE)/WPILib.  */
/*----------------------------------------------------------------------------*/

#ifndef ROBOT_ITERATIVE_H_
#define ROBOT_ITERATIVE_H_

#include "CppBot_types.h"
#include "RobotBase.h"

/**
 * IterativeRobot implements a specific type of Robot Program framework, extending the RobotBase class.
 * 
 * The IterativeRobot class is intended to be subclassed by a user creating a robot program.
 * 
 * This class is intended to implement the "old style" default code, by providing
 * the following functions which are called by the main loop, StartCompetition(), at the appropriate times:
 * 
 * RobotInit() -- provide for initialization at robot power-on
 * 
 * Init() functions -- each of the following functions is called once when the
 *                     appropriate mode is entered:
 *  - DisabledInit()   -- called only when first disabled
 *  - AutonomousInit() -- called each and every time autonomous is entered from another mode
 *  - TeleopInit()     -- called each and every time teleop is entered from another mode
 * 
 * Periodic() functions -- each of these functions is called iteratively at the
 *                         appropriate periodic rate (aka the "slow loop").  The default period of
 *                         the iterative robot is 0.005 seconds, giving a periodic frequency
 *                         of 200Hz (200 times per second).
 *   - DisabledPeriodic()
 *   - AutonomousPeriodic()
 *   - TeleopPeriodic()
 * 
 * Continuous() functions -- each of these functions is called repeatedly as
 *                           fast as possible:
 *   - DisabledContinuous()
 *   - AutonomousContinuous()
 *   - TeleopContinuous()
 * 
 */

class IterativeRobot : public RobotBase {
public:
	//TODO: static const double kDefaultPeriod = 5e-3;	/** default period for periodic functions **/
	//TODO: virtual void StartCompetition();

	//TODO: virtual void DisabledContinuous();
	//TODO: virtual void AutonomousContinuous();
	//TODO: virtual void TeleopContinuous();

	//TODO: void SetPeriod(double period);
	//TODO: double GetLoopsPerSec();

protected:
	//TODO: virtual ~IterativeRobot();
	//TODO: IterativeRobot();

private:
	//TODO: bool NextPeriodReady();

	//TODO: bool m_disabledInitialized;
	//TODO: bool m_autonomousInitialized;
	//TODO: bool m_teleopInitialized;
	//TODO: UINT32 m_disabledLoops;
	//TODO: UINT32 m_autonomousLoops;
	//TODO: UINT32 m_teleopLoops;
	//TODO: double m_period;
};

#endif

