/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.AnalogChannel;
import edu.wpi.first.wpilibj.Dashboard;
import edu.wpi.first.wpilibj.DriverStationEnhancedIO;
import edu.wpi.first.wpilibj.IDashboard;
import edu.wpi.first.wpilibj.MotorSafetyHelper;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.communication.FRCCommonControlData;
import edu.wpi.first.wpilibj.communication.FRCControl;
import edu.wpi.first.wpilibj.communication.Semaphore;
import edu.wpi.first.wpilibj.communication.SemaphoreException;
import edu.wpi.first.wpilibj.parsing.IInputOutput;

public class DriverStation
implements IInputOutput {
    public static final int USER_CONTROL_DATA_SIZE = 904;
    public static final int USER_STATUS_DATA_SIZE = 984;
    public static final int kBatterySlot = 1;
    public static final int kBatteryChannel = 8;
    public static final int kJoystickPorts = 4;
    public static final int kJoystickAxes = 6;
    public static final double kDSAnalogInScaling = 0.004887585532746823;
    private static DriverStation instance = new DriverStation();
    private FRCCommonControlData m_controlData;
    private AnalogChannel m_batteryChannel;
    private Thread m_thread;
    private final Object m_semaphore;
    private final Object m_dataSem;
    private int m_digitalOut;
    private volatile boolean m_thread_keepalive = true;
    private final Dashboard m_dashboardDefaultHigh;
    private final Dashboard m_dashboardDefaultLow;
    private IDashboard m_dashboardInUseHigh;
    private IDashboard m_dashboardInUseLow;
    private int m_updateNumber = 0;
    private double m_approxMatchTimeOffset = -1.0;
    private boolean m_userInDisabled = false;
    private boolean m_userInAutonomous = false;
    private boolean m_userInTeleop = false;
    private boolean m_newControlData;
    private final Semaphore m_packetDataAvailableSem;
    private DriverStationEnhancedIO m_enhancedIO = new DriverStationEnhancedIO();
    private static boolean lastEnabled = false;

    public static DriverStation getInstance() {
        return instance;
    }

    protected DriverStation() {
        this.m_controlData = new FRCCommonControlData();
        this.m_semaphore = new Object();
        this.m_dataSem = new Object();
        this.m_dashboardDefaultHigh = new Dashboard(this.m_semaphore);
        this.m_dashboardInUseHigh = this.m_dashboardDefaultHigh;
        this.m_dashboardDefaultLow = new Dashboard(this.m_semaphore);
        this.m_dashboardInUseLow = this.m_dashboardDefaultLow;
        this.m_batteryChannel = new AnalogChannel(1, 8);
        Semaphore.Options options = new Semaphore.Options();
        options.setPrioritySorted(true);
        this.m_packetDataAvailableSem = new Semaphore(options, false);
        FRCControl.setNewDataSem(this.m_packetDataAvailableSem);
        this.m_thread = new Thread((Runnable)new DriverStationTask(this), "FRCDriverStation");
        this.m_thread.setPriority(7);
        this.m_thread.start();
    }

    public void release() {
        this.m_thread_keepalive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void task() {
        int safetyCounter = 0;
        while (this.m_thread_keepalive) {
            try {
                this.m_packetDataAvailableSem.takeForever();
                Object object = this;
                synchronized (object) {
                    this.getData();
                    this.m_enhancedIO.updateData();
                    this.setData();
                }
                object = this.m_dataSem;
                synchronized (object) {
                    this.m_dataSem.notifyAll();
                }
                if (++safetyCounter >= 5) {
                    MotorSafetyHelper.checkMotors();
                    safetyCounter = 0;
                }
                if (this.m_userInDisabled) {
                    FRCControl.observeUserProgramDisabled();
                }
                if (this.m_userInAutonomous) {
                    FRCControl.observeUserProgramAutonomous();
                }
                if (!this.m_userInTeleop) continue;
                FRCControl.observeUserProgramTeleop();
            }
            catch (SemaphoreException semaphoreException) {}
        }
    }

    public void waitForData() {
        this.waitForData(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForData(long timeout) {
        Object object = this.m_dataSem;
        synchronized (object) {
            try {
                this.m_dataSem.wait(timeout);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
    }

    protected synchronized void getData() {
        FRCControl.getCommonControlData(this.m_controlData, -1);
        if (!lastEnabled && this.isEnabled()) {
            this.m_approxMatchTimeOffset = this.isAutonomous() ? Timer.getFPGATimestamp() : Timer.getFPGATimestamp() - 15.0;
        } else if (lastEnabled && !this.isEnabled()) {
            this.m_approxMatchTimeOffset = -1.0;
        }
        lastEnabled = this.isEnabled();
        this.m_newControlData = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setData() {
        Object object = this.m_semaphore;
        synchronized (object) {
            FRCControl.setStatusData(this.getBatteryVoltage(), this.m_digitalOut, this.m_updateNumber, this.m_dashboardInUseHigh.getBytes(), this.m_dashboardInUseHigh.getBytesLength(), this.m_dashboardInUseLow.getBytes(), this.m_dashboardInUseLow.getBytesLength(), -1);
            this.m_dashboardInUseHigh.flush();
            this.m_dashboardInUseLow.flush();
        }
    }

    public double getBatteryVoltage() {
        return this.m_batteryChannel.getAverageVoltage() * 1.68;
    }

    public double getStickAxis(int stick, int axis) {
        byte value;
        if (axis < 1 || axis > 6) {
            return 0.0;
        }
        switch (stick) {
            case 1: {
                value = this.m_controlData.stick0Axes[axis - 1];
                break;
            }
            case 2: {
                value = this.m_controlData.stick1Axes[axis - 1];
                break;
            }
            case 3: {
                value = this.m_controlData.stick2Axes[axis - 1];
                break;
            }
            case 4: {
                value = this.m_controlData.stick3Axes[axis - 1];
                break;
            }
            default: {
                return 0.0;
            }
        }
        double result = value < 0 ? (double)value / 128.0 : (double)value / 127.0;
        if (result > 1.0) {
            result = 1.0;
        } else if (result < -1.0) {
            result = -1.0;
        }
        return result;
    }

    public int getStickButtons(int stick) {
        switch (stick) {
            case 1: {
                return this.m_controlData.stick0Buttons;
            }
            case 2: {
                return this.m_controlData.stick1Buttons;
            }
            case 3: {
                return this.m_controlData.stick2Buttons;
            }
            case 4: {
                return this.m_controlData.stick3Buttons;
            }
        }
        return 0;
    }

    public double getAnalogIn(int channel) {
        switch (channel) {
            case 1: {
                return 0.004887585532746823 * (double)this.m_controlData.analog1;
            }
            case 2: {
                return 0.004887585532746823 * (double)this.m_controlData.analog2;
            }
            case 3: {
                return 0.004887585532746823 * (double)this.m_controlData.analog3;
            }
            case 4: {
                return 0.004887585532746823 * (double)this.m_controlData.analog4;
            }
        }
        return 0.0;
    }

    public boolean getDigitalIn(int channel) {
        return (this.m_controlData.dsDigitalIn >> channel - 1 & 1) == 1;
    }

    public void setDigitalOut(int channel, boolean value) {
        this.m_digitalOut &= ~(1 << channel - 1);
        this.m_digitalOut |= (value ? 1 : 0) << channel - 1;
    }

    public boolean getDigitalOut(int channel) {
        return (this.m_digitalOut >> channel - 1 & 1) == 1;
    }

    public boolean isEnabled() {
        return this.m_controlData.enabled();
    }

    public boolean isDisabled() {
        return !this.m_controlData.enabled();
    }

    public boolean isAutonomous() {
        return this.m_controlData.autonomous();
    }

    public boolean isOperatorControl() {
        return !this.m_controlData.autonomous();
    }

    public synchronized boolean isNewControlData() {
        boolean result = this.m_newControlData;
        this.m_newControlData = false;
        return result;
    }

    public int getPacketNumber() {
        return this.m_controlData.packetIndex;
    }

    public Alliance getAlliance() {
        switch (this.m_controlData.dsID_Alliance) {
            case 'R': {
                return Alliance.kRed;
            }
            case 'B': {
                return Alliance.kBlue;
            }
        }
        return Alliance.kInvalid;
    }

    public int getLocation() {
        return this.m_controlData.dsID_Position - 48;
    }

    public int getTeamNumber() {
        return this.m_controlData.teamID;
    }

    public void setDashboardPackerToUseHigh(IDashboard dashboard) {
        this.m_dashboardInUseHigh = dashboard;
    }

    public Dashboard getDashboardPackerHigh() {
        return this.m_dashboardDefaultHigh;
    }

    public IDashboard getDashboardPackerInUseHigh() {
        return this.m_dashboardInUseHigh;
    }

    public void setDashboardPackerToUseLow(IDashboard dashboard) {
        this.m_dashboardInUseLow = dashboard;
    }

    public Dashboard getDashboardPackerLow() {
        return this.m_dashboardDefaultLow;
    }

    public IDashboard getDashboardPackerInUseLow() {
        return this.m_dashboardInUseLow;
    }

    public Object getStatusDataMonitor() {
        return this.m_semaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementUpdateNumber() {
        Object object = this.m_semaphore;
        synchronized (object) {
            ++this.m_updateNumber;
        }
    }

    public boolean isFMSAttached() {
        return (this.m_controlData.control & 8) > 0;
    }

    public DriverStationEnhancedIO getEnhancedIO() {
        return this.m_enhancedIO;
    }

    public double getMatchTime() {
        if (this.m_approxMatchTimeOffset < 0.0) {
            return 0.0;
        }
        return Timer.getFPGATimestamp() - this.m_approxMatchTimeOffset;
    }

    private static class DriverStationTask
    implements Runnable {
        private DriverStation m_ds;

        DriverStationTask(DriverStation ds) {
            this.m_ds = ds;
        }

        public void run() {
            this.m_ds.task();
        }
    }

    public static class Alliance {
        public final int value;
        public final String name;
        public static final int kRed_val = 0;
        public static final int kBlue_val = 1;
        public static final int kInvalid_val = 2;
        public static final Alliance kRed = new Alliance(0, "Red");
        public static final Alliance kBlue = new Alliance(1, "Blue");
        public static final Alliance kInvalid = new Alliance(2, "invalid");

        private Alliance(int value, String name) {
            this.value = value;
            this.name = name;
        }
    }
}

