/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.RobotBase;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.communication.FRCControl;

public class IterativeRobot
extends RobotBase {
    private static final boolean TRACE_LOOP_ALLOCATIONS = false;
    private static final boolean TRACE_LOOP_ALLOCATIONS_AFTER_INIT = true;
    private boolean m_disabledInitialized = false;
    private boolean m_autonomousInitialized = false;
    private boolean m_teleopInitialized = false;
    private boolean dpFirstRun = true;
    private boolean apFirstRun = true;
    private boolean tpFirstRun = true;
    private boolean dcFirstRun = true;
    private boolean acFirstRun = true;
    private boolean tcFirstRun = true;

    public void startCompetition() {
        this.robotInit();
        int TRACE_LOOP_MAX = 100;
        int loopCount = 100;
        Object marker = null;
        boolean didDisabledPeriodic = false;
        boolean didAutonomousPeriodic = false;
        boolean didTeleopPeriodic = false;
        while (true) {
            if (this.isDisabled()) {
                if (!this.m_disabledInitialized) {
                    this.disabledInit();
                    this.m_disabledInitialized = true;
                    this.m_autonomousInitialized = false;
                    this.m_teleopInitialized = false;
                }
                if (this.nextPeriodReady()) {
                    FRCControl.observeUserProgramDisabled();
                    this.disabledPeriodic();
                    didDisabledPeriodic = true;
                }
                this.disabledContinuous();
                continue;
            }
            if (this.isAutonomous()) {
                if (!this.m_autonomousInitialized) {
                    this.autonomousInit();
                    this.m_autonomousInitialized = true;
                    this.m_teleopInitialized = false;
                    this.m_disabledInitialized = false;
                }
                if (this.nextPeriodReady()) {
                    this.getWatchdog().feed();
                    FRCControl.observeUserProgramAutonomous();
                    this.autonomousPeriodic();
                    didAutonomousPeriodic = true;
                }
                this.autonomousContinuous();
                continue;
            }
            if (!this.m_teleopInitialized) {
                this.teleopInit();
                this.m_teleopInitialized = true;
                this.m_autonomousInitialized = false;
                this.m_disabledInitialized = false;
            }
            if (this.nextPeriodReady()) {
                this.getWatchdog().feed();
                FRCControl.observeUserProgramTeleop();
                this.teleopPeriodic();
                didTeleopPeriodic = true;
            }
            this.teleopContinuous();
        }
    }

    private boolean nextPeriodReady() {
        return this.m_ds.isNewControlData();
    }

    public void robotInit() {
        System.out.println("Default IterativeRobot.robotInit() method... Overload me!");
    }

    public void disabledInit() {
        System.out.println("Default IterativeRobot.disabledInit() method... Overload me!");
    }

    public void autonomousInit() {
        System.out.println("Default IterativeRobot.autonomousInit() method... Overload me!");
    }

    public void teleopInit() {
        System.out.println("Default IterativeRobot.teleopInit() method... Overload me!");
    }

    public void disabledPeriodic() {
        if (this.dpFirstRun) {
            System.out.println("Default IterativeRobot.disabledPeriodic() method... Overload me!");
            this.dpFirstRun = false;
        }
        Timer.delay(0.001);
    }

    public void autonomousPeriodic() {
        if (this.apFirstRun) {
            System.out.println("Default IterativeRobot.autonomousPeriodic() method... Overload me!");
            this.apFirstRun = false;
        }
        Timer.delay(0.001);
    }

    public void teleopPeriodic() {
        if (this.tpFirstRun) {
            System.out.println("Default IterativeRobot.teleopPeriodic() method... Overload me!");
            this.tpFirstRun = false;
        }
        Timer.delay(0.001);
    }

    public void disabledContinuous() {
        if (this.dcFirstRun) {
            System.out.println("Default IterativeRobot.disabledContinuous() method... Overload me!");
            this.dcFirstRun = false;
        }
        this.m_ds.waitForData();
    }

    public void autonomousContinuous() {
        if (this.acFirstRun) {
            System.out.println("Default IterativeRobot.autonomousContinuous() method... Overload me!");
            this.acFirstRun = false;
        }
        this.m_ds.waitForData();
    }

    public void teleopContinuous() {
        if (this.tcFirstRun) {
            System.out.println("Default IterativeRobot.teleopContinuous() method... Overload me!");
            this.tcFirstRun = false;
        }
        this.m_ds.waitForData();
    }
}

