/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.Watchdog;
import edu.wpi.first.wpilibj.communication.FRCControl;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public abstract class RobotBase
extends MIDlet {
    public static final int ROBOT_TASK_PRIORITY = 101;
    public static final String ERRORS_TO_DRIVERSTATION_PROP = "first.driverstation.senderrors";
    protected final DriverStation m_ds;
    private final Watchdog m_watchdog = Watchdog.getInstance();

    protected RobotBase() {
        this.m_ds = DriverStation.getInstance();
        this.m_watchdog.setEnabled(false);
    }

    public void free() {
    }

    public boolean isSystemActive() {
        return this.m_watchdog.isSystemActive();
    }

    public Watchdog getWatchdog() {
        return this.m_watchdog;
    }

    public boolean isDisabled() {
        return this.m_ds.isDisabled();
    }

    public boolean isEnabled() {
        return this.m_ds.isEnabled();
    }

    public boolean isAutonomous() {
        return this.m_ds.isAutonomous();
    }

    public boolean isOperatorControl() {
        return this.m_ds.isOperatorControl();
    }

    public boolean isNewDataAvailable() {
        return this.m_ds.isNewControlData();
    }

    public abstract void startCompetition();

    public static boolean getBooleanProperty(String name, boolean defaultValue) {
        String propVal = System.getProperty(name);
        if (propVal == null) {
            return defaultValue;
        }
        if (propVal.equalsIgnoreCase("false")) {
            return false;
        }
        if (propVal.equalsIgnoreCase("true")) {
            return true;
        }
        throw new IllegalStateException(propVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void startApp() throws MIDletStateChangeException {
        boolean errorOnExit = false;
        Watchdog.getInstance().setExpiration(0.1);
        Watchdog.getInstance().setEnabled(false);
        FRCControl.observeUserProgramStarting();
        UsageReporting.report(2, 3);
        try {
            this.startCompetition();
        }
        catch (Throwable t) {
            t.printStackTrace();
            errorOnExit = true;
        }
        finally {
            System.err.println("WARNING: Robots don't quit!");
            if (errorOnExit) {
                System.err.println("---> The startCompetition() method (or methods called by it) should have handled the exception above.");
            } else {
                System.err.println("---> Unexpected return from startCompetition() method.");
            }
        }
    }

    protected final void pauseApp() {
    }

    protected final void destroyApp(boolean unconditional) throws MIDletStateChangeException {
    }
}

