/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.buttons;

import edu.wpi.first.wpilibj.command.Command;
import edu.wpi.first.wpilibj.command.Scheduler;
import edu.wpi.first.wpilibj.networktables.NetworkTable;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboardData;

public abstract class Button
implements SmartDashboardData {
    private NetworkTable table;

    public abstract boolean get();

    private boolean grab() {
        return this.get() || this.table != null && this.table.isConnected() && this.table.getBoolean("pressed", false);
    }

    public void whenPressed(final Command command) {
        new ButtonScheduler(){
            boolean pressedLast;
            {
                this.pressedLast = Button.this.grab();
            }

            public void execute() {
                if (Button.this.grab()) {
                    if (!this.pressedLast) {
                        this.pressedLast = true;
                        command.start();
                    }
                } else {
                    this.pressedLast = false;
                }
            }
        }.start();
    }

    public void whileHeld(final Command command) {
        new ButtonScheduler(){
            boolean pressedLast;
            {
                this.pressedLast = Button.this.grab();
            }

            public void execute() {
                if (Button.this.grab()) {
                    this.pressedLast = true;
                    command.start();
                } else if (this.pressedLast) {
                    this.pressedLast = false;
                    command.cancel();
                }
            }
        }.start();
    }

    public void whenReleased(final Command command) {
        new ButtonScheduler(){
            boolean pressedLast;
            {
                this.pressedLast = Button.this.grab();
            }

            public void execute() {
                if (Button.this.grab()) {
                    this.pressedLast = true;
                } else if (this.pressedLast) {
                    this.pressedLast = false;
                    command.start();
                }
            }
        }.start();
    }

    public String getType() {
        return "Button";
    }

    public NetworkTable getTable() {
        if (this.table == null) {
            this.table = new NetworkTable();
            this.table.putBoolean("pressed", this.get());
        }
        return this.table;
    }

    public abstract class ButtonScheduler {
        public abstract void execute();

        protected void start() {
            Scheduler.getInstance().addButton(this);
        }
    }
}

