/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.command;

import edu.wpi.first.wpilibj.command.Command;
import edu.wpi.first.wpilibj.command.IllegalUseOfCommandException;
import edu.wpi.first.wpilibj.command.Scheduler;
import edu.wpi.first.wpilibj.networktables.NetworkTable;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboardNamedData;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Subsystem
implements SmartDashboardNamedData {
    private boolean initializedDefaultCommand = false;
    private Command currentCommand;
    private Command defaultCommand;
    private String name;
    private static Vector allSubsystems = new Vector();
    private NetworkTable table;

    public Subsystem(String name) {
        this.name = name;
        Scheduler.getInstance().registerSubsystem(this);
    }

    public Subsystem() {
        this.name = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
        Scheduler.getInstance().registerSubsystem(this);
    }

    protected abstract void initDefaultCommand();

    protected void setDefaultCommand(Command command) {
        if (command == null) {
            this.defaultCommand = null;
        } else {
            boolean found = false;
            Enumeration requirements = command.getRequirements();
            while (requirements.hasMoreElements()) {
                if (!requirements.nextElement().equals(this)) continue;
                found = true;
            }
            if (!found) {
                throw new IllegalUseOfCommandException("A default command must require the subsystem");
            }
            this.defaultCommand = command;
        }
        if (this.table != null) {
            if (this.defaultCommand != null) {
                this.table.putBoolean("hasDefault", true);
                this.table.putSubTable("default", this.defaultCommand.getTable());
            } else {
                this.table.putBoolean("hasDefault", false);
            }
        }
    }

    protected Command getDefaultCommand() {
        if (!this.initializedDefaultCommand) {
            this.initializedDefaultCommand = true;
            this.initDefaultCommand();
        }
        return this.defaultCommand;
    }

    void setCurrentCommand(Command command) {
        this.currentCommand = command;
    }

    void confirmCommand() {
        if (this.table != null) {
            if (this.currentCommand != null) {
                this.table.putBoolean("hasCommand", true);
                this.table.putSubTable("command", this.currentCommand.getTable());
            } else {
                this.table.putBoolean("hasCommand", false);
            }
        }
    }

    public Command getCurrentCommand() {
        return this.currentCommand;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return "Subsystem";
    }

    NetworkTable grabTable() {
        return new NetworkTable();
    }

    public NetworkTable getTable() {
        if (this.table == null) {
            this.table = this.grabTable();
            if (this.defaultCommand != null) {
                this.table.putBoolean("hasDefault", true);
                this.table.putSubTable("default", this.defaultCommand.getTable());
            } else {
                this.table.putBoolean("hasDefault", false);
            }
            if (this.currentCommand != null) {
                this.table.putBoolean("hasCommand", true);
                this.table.putSubTable("command", this.currentCommand.getTable());
            } else {
                this.table.putBoolean("hasCommand", false);
            }
        }
        return this.table;
    }
}

