/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.fpga;

import com.ni.rio.NiFpga;
import edu.wpi.first.wpilibj.fpga.tSystem;

public class tAnalogTrigger
extends tSystem {
    public static final int kNumSystems = 8;
    public final int m_SystemIndex;
    private static final int kSourceSelect_Channel_BitfieldMask = 28672;
    private static final int kSourceSelect_Channel_BitfieldOffset = 12;
    private static final int kSourceSelect_Module_BitfieldMask = 2048;
    private static final int kSourceSelect_Module_BitfieldOffset = 11;
    private static final int kSourceSelect_Averaged_BitfieldMask = 1024;
    private static final int kSourceSelect_Averaged_BitfieldOffset = 10;
    private static final int kSourceSelect_Filter_BitfieldMask = 512;
    private static final int kSourceSelect_Filter_BitfieldOffset = 9;
    private static final int kSourceSelect_FloatingRollover_BitfieldMask = 256;
    private static final int kSourceSelect_FloatingRollover_BitfieldOffset = 8;
    private static final int kSourceSelect_RolloverLimit_BitfieldMask = 255;
    private static final int kSourceSelect_RolloverLimit_BitfieldOffset = 0;
    private static final int kSourceSelect_RolloverLimit_FixedPointIntegerShift = 4;
    private static final int kAnalogTrigger0_SourceSelect_Address = 33184;
    private static final int kAnalogTrigger1_SourceSelect_Address = 33196;
    private static final int kAnalogTrigger2_SourceSelect_Address = 33208;
    private static final int kAnalogTrigger3_SourceSelect_Address = 33220;
    private static final int kAnalogTrigger4_SourceSelect_Address = 33232;
    private static final int kAnalogTrigger5_SourceSelect_Address = 33244;
    private static final int kAnalogTrigger6_SourceSelect_Address = 33256;
    private static final int kAnalogTrigger7_SourceSelect_Address = 33268;
    private static final int[] kSourceSelect_Addresses = new int[]{33184, 33196, 33208, 33220, 33232, 33244, 33256, 33268};
    private static final int kAnalogTrigger0_UpperLimit_Address = 33188;
    private static final int kAnalogTrigger1_UpperLimit_Address = 33200;
    private static final int kAnalogTrigger2_UpperLimit_Address = 33212;
    private static final int kAnalogTrigger3_UpperLimit_Address = 33224;
    private static final int kAnalogTrigger4_UpperLimit_Address = 33236;
    private static final int kAnalogTrigger5_UpperLimit_Address = 33260;
    private static final int kAnalogTrigger6_UpperLimit_Address = 33248;
    private static final int kAnalogTrigger7_UpperLimit_Address = 33272;
    private static final int[] kUpperLimit_Addresses = new int[]{33188, 33200, 33212, 33224, 33236, 33260, 33248, 33272};
    private static final int kAnalogTrigger0_LowerLimit_Address = 33192;
    private static final int kAnalogTrigger1_LowerLimit_Address = 33204;
    private static final int kAnalogTrigger2_LowerLimit_Address = 33216;
    private static final int kAnalogTrigger3_LowerLimit_Address = 33228;
    private static final int kAnalogTrigger4_LowerLimit_Address = 33240;
    private static final int kAnalogTrigger5_LowerLimit_Address = 33264;
    private static final int kAnalogTrigger6_LowerLimit_Address = 33252;
    private static final int kAnalogTrigger7_LowerLimit_Address = 33276;
    private static final int[] kLowerLimit_Addresses = new int[]{33192, 33204, 33216, 33228, 33240, 33264, 33252, 33276};
    public static final int kOutput_NumElements = 8;
    public static final int kOutput_ElementSize = 4;
    public static final int kOutput_ElementMask = 15;
    private static final int kOutput_InHysteresis_BitfieldMask = 8;
    private static final int kOutput_InHysteresis_BitfieldOffset = 3;
    private static final int kOutput_OverLimit_BitfieldMask = 4;
    private static final int kOutput_OverLimit_BitfieldOffset = 2;
    private static final int kOutput_Rising_BitfieldMask = 2;
    private static final int kOutput_Rising_BitfieldOffset = 1;
    private static final int kOutput_Falling_BitfieldMask = 1;
    private static final int kOutput_Falling_BitfieldOffset = 0;
    private static final int kAnalogTrigger_Output_Address = 33180;

    public tAnalogTrigger(int sys_index) {
        this.m_SystemIndex = sys_index;
        if (status.isNotFatal() && this.m_SystemIndex >= 8) {
            status.setStatus(-50003);
        }
    }

    protected void finalize() {
        super.finalize();
    }

    public int getSystemIndex() {
        return this.m_SystemIndex;
    }

    public void writeSourceSelect(int value) {
        NiFpga.writeU32(m_DeviceHandle, kSourceSelect_Addresses[this.m_SystemIndex], value, status);
    }

    public void writeSourceSelect_Channel(int value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kSourceSelect_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFF8FFF;
        NiFpga.writeU32(m_DeviceHandle, kSourceSelect_Addresses[this.m_SystemIndex], regValue |= value << 12 & 0x7000, status);
    }

    public void writeSourceSelect_Module(int value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kSourceSelect_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFF7FF;
        NiFpga.writeU32(m_DeviceHandle, kSourceSelect_Addresses[this.m_SystemIndex], regValue |= value << 11 & 0x800, status);
    }

    public void writeSourceSelect_Averaged(boolean value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kSourceSelect_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFBFF;
        NiFpga.writeU32(m_DeviceHandle, kSourceSelect_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 10 & 0x400, status);
    }

    public void writeSourceSelect_Filter(boolean value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kSourceSelect_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFDFF;
        NiFpga.writeU32(m_DeviceHandle, kSourceSelect_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 9 & 0x200, status);
    }

    public void writeSourceSelect_FloatingRollover(boolean value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kSourceSelect_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFEFF;
        NiFpga.writeU32(m_DeviceHandle, kSourceSelect_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 8 & 0x100, status);
    }

    public void writeSourceSelect_RolloverLimit(int value) {
        int regValue = NiFpga.readU32(m_DeviceHandle, kSourceSelect_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFF00;
        NiFpga.writeU32(m_DeviceHandle, kSourceSelect_Addresses[this.m_SystemIndex], regValue |= value >>> 4 << 0 & 0xFF, status);
    }

    public int readSourceSelect() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kSourceSelect_Addresses[this.m_SystemIndex], status);
        return regValue;
    }

    public byte readSourceSelect_Channel() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kSourceSelect_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x7000) >>> 12;
        return (byte)(bitfieldValue & 7);
    }

    public byte readSourceSelect_Module() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kSourceSelect_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x800) >>> 11;
        return (byte)(bitfieldValue & 1);
    }

    public boolean readSourceSelect_Averaged() {
        int result = NiFpga.readU32(m_DeviceHandle, kSourceSelect_Addresses[this.m_SystemIndex], status);
        int regValue = result;
        int bitfieldValue = (regValue & 0x400) >>> 10;
        return bitfieldValue != 0;
    }

    public boolean readSourceSelect_Filter() {
        int result = NiFpga.readU32(m_DeviceHandle, kSourceSelect_Addresses[this.m_SystemIndex], status);
        int regValue = result;
        int bitfieldValue = (regValue & 0x200) >>> 9;
        return bitfieldValue != 0;
    }

    public boolean readSourceSelect_FloatingRollover() {
        int result = NiFpga.readU32(m_DeviceHandle, kSourceSelect_Addresses[this.m_SystemIndex], status);
        int regValue = result;
        int bitfieldValue = (regValue & 0x100) >>> 8;
        return bitfieldValue != 0;
    }

    public short readSourceSelect_RolloverLimit() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, kSourceSelect_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xFF) >>> 0 << 4;
        bitfieldValue <<= 20;
        return (short)(bitfieldValue >>= 20);
    }

    public void writeUpperLimit(int value) {
        NiFpga.writeU32(m_DeviceHandle, kUpperLimit_Addresses[this.m_SystemIndex], value, status);
    }

    public int readUpperLimit() {
        return NiFpga.readU32(m_DeviceHandle, kUpperLimit_Addresses[this.m_SystemIndex], status);
    }

    public void writeLowerLimit(int value) {
        NiFpga.writeU32(m_DeviceHandle, kLowerLimit_Addresses[this.m_SystemIndex], value, status);
    }

    public int readLowerLimit() {
        return NiFpga.readU32(m_DeviceHandle, kLowerLimit_Addresses[this.m_SystemIndex], status);
    }

    public static int readOutput(int bitfield_index) {
        if (status.isNotFatal() && bitfield_index >= 8) {
            status.setStatus(-50003);
        }
        int result = NiFpga.readU32(m_DeviceHandle, 33180, status);
        int regValue = result >>> (7 - bitfield_index) * 4;
        return regValue;
    }

    public static boolean readOutput_InHysteresis(int bitfield_index) {
        int result;
        int regValue;
        int bitfieldValue;
        if (status.isNotFatal() && bitfield_index >= 8) {
            status.setStatus(-50003);
        }
        return (bitfieldValue = ((regValue = (result = NiFpga.readU32(m_DeviceHandle, 33180, status)) >>> (7 - bitfield_index) * 4) & 8) >>> 3) != 0;
    }

    public static boolean readOutput_OverLimit(int bitfield_index) {
        int result;
        int regValue;
        int bitfieldValue;
        if (status.isNotFatal() && bitfield_index >= 8) {
            status.setStatus(-50003);
        }
        return (bitfieldValue = ((regValue = (result = NiFpga.readU32(m_DeviceHandle, 33180, status)) >>> (7 - bitfield_index) * 4) & 4) >>> 2) != 0;
    }

    public static boolean readOutput_Rising(int bitfield_index) {
        int result;
        int regValue;
        int bitfieldValue;
        if (status.isNotFatal() && bitfield_index >= 8) {
            status.setStatus(-50003);
        }
        return (bitfieldValue = ((regValue = (result = NiFpga.readU32(m_DeviceHandle, 33180, status)) >>> (7 - bitfield_index) * 4) & 2) >>> 1) != 0;
    }

    public static boolean readOutput_Falling(int bitfield_index) {
        int result;
        int regValue;
        int bitfieldValue;
        if (status.isNotFatal() && bitfield_index >= 8) {
            status.setStatus(-50003);
        }
        return (bitfieldValue = ((regValue = (result = NiFpga.readU32(m_DeviceHandle, 33180, status)) >>> (7 - bitfield_index) * 4) & 1) >>> 0) != 0;
    }
}

