/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.fpga;

import com.ni.rio.NiFpga;
import edu.wpi.first.wpilibj.fpga.tSystem;

public class tWatchdog
extends tSystem {
    public static final int kNumSystems = 1;
    private static final int kStatus_SystemActive_BitfieldMask = Integer.MIN_VALUE;
    private static final int kStatus_SystemActive_BitfieldOffset = 31;
    private static final int kStatus_Alive_BitfieldMask = 0x40000000;
    private static final int kStatus_Alive_BitfieldOffset = 30;
    private static final int kStatus_SysDisableCount_BitfieldMask = 1073709056;
    private static final int kStatus_SysDisableCount_BitfieldOffset = 15;
    private static final int kStatus_DisableCount_BitfieldMask = Short.MAX_VALUE;
    private static final int kStatus_DisableCount_BitfieldOffset = 0;
    private static final int kWatchdog_Status_Address = 33052;
    private static final int kWatchdog_Kill_Address = 33060;
    private static final int kWatchdog_Feed_Address = 33056;
    private static final int kWatchdog_Timer_Address = 33064;
    private static final int kWatchdog_Expiration_Address = 33068;
    private static final int kWatchdog_Immortal_Address = 33072;

    protected void finalize() {
        super.finalize();
    }

    public static int readStatus() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, 33052, status);
        return regValue;
    }

    public static boolean readStatus_SystemActive() {
        int result = NiFpga.readU32(m_DeviceHandle, 33052, status);
        int regValue = result;
        int bitfieldValue = (regValue & Integer.MIN_VALUE) >>> 31;
        return bitfieldValue != 0;
    }

    public static boolean readStatus_Alive() {
        int result = NiFpga.readU32(m_DeviceHandle, 33052, status);
        int regValue = result;
        int bitfieldValue = (regValue & 0x40000000) >>> 30;
        return bitfieldValue != 0;
    }

    public static short readStatus_SysDisableCount() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, 33052, status);
        int bitfieldValue = (regValue & 0x3FFF8000) >>> 15;
        return (short)(bitfieldValue & Short.MAX_VALUE);
    }

    public static short readStatus_DisableCount() {
        int result;
        int regValue = result = NiFpga.readU32(m_DeviceHandle, 33052, status);
        int bitfieldValue = (regValue & Short.MAX_VALUE) >>> 0;
        return (short)(bitfieldValue & Short.MAX_VALUE);
    }

    public static void strobeKill() {
        NiFpga.writeU32(m_DeviceHandle, 33060, 1, status);
    }

    public static void strobeFeed() {
        NiFpga.writeU32(m_DeviceHandle, 33056, 1, status);
    }

    public static long readTimer() {
        return (long)NiFpga.readU32(m_DeviceHandle, 33064, status) & 0xFFFFFFFFL;
    }

    public static void writeExpiration(long value) {
        NiFpga.writeU32(m_DeviceHandle, 33068, (int)value, status);
    }

    public static long readExpiration() {
        return (long)NiFpga.readU32(m_DeviceHandle, 33068, status) & 0xFFFFFFFFL;
    }

    public static void writeImmortal(boolean value) {
        NiFpga.writeU32(m_DeviceHandle, 33072, value ? 1 : 0, status);
    }

    public static boolean readImmortal() {
        return NiFpga.readU32(m_DeviceHandle, 33072, status) != 0;
    }
}

