/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.templates.subsystems;

import edu.wpi.first.wpilibj.DigitalInput;
import edu.wpi.first.wpilibj.Solenoid;
import edu.wpi.first.wpilibj.command.Subsystem;

public class BridgeArm
extends Subsystem {
    Solenoid m_arm1 = new Solenoid(7);
    Solenoid m_arm2 = new Solenoid(8);
    DigitalInput m_armUpSwitch = new DigitalInput(14);
    DigitalInput m_armDownSwitch = new DigitalInput(13);
    private boolean changed = false;

    public void initDefaultCommand() {
    }

    public void armDown() {
        this.m_arm1.set(false);
        this.m_arm2.set(true);
        this.changed = true;
    }

    public void armUp() {
        this.m_arm1.set(true);
        this.m_arm2.set(false);
        this.changed = true;
    }

    public void armToggle() {
        this.changed = false;
        if (!this.m_arm1.get()) {
            this.m_arm1.set(true);
            this.m_arm2.set(false);
            this.changed = true;
        } else if (this.m_arm1.get()) {
            this.m_arm1.set(false);
            this.m_arm2.set(true);
            this.changed = true;
        }
    }

    public boolean getSolenoid() {
        return this.m_arm1.get();
    }

    public boolean positionChanged() {
        return this.changed;
    }
}

