/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.templates.subsystems;

import edu.wpi.first.wpilibj.GearTooth;
import edu.wpi.first.wpilibj.Joystick;
import edu.wpi.first.wpilibj.Solenoid;
import edu.wpi.first.wpilibj.Victor;
import edu.wpi.first.wpilibj.command.Subsystem;
import edu.wpi.first.wpilibj.templates.RobotMap;
import edu.wpi.first.wpilibj.templates.commands.highlevel.H_DriveWithJoystick;

public class Chassis
extends Subsystem {
    Victor m_rightMotor = new Victor(2);
    Victor m_leftMotor = new Victor(1);
    Solenoid m_shifter1 = new Solenoid(1);
    Solenoid m_shifter2 = new Solenoid(2);
    GearTooth m_rightEncoder = new GearTooth(6);
    GearTooth m_leftEncoder = new GearTooth(5);
    private boolean shifted = false;

    public void initDefaultCommand() {
        this.setDefaultCommand(new H_DriveWithJoystick());
    }

    public void straight(int dir) {
        if (dir == -1) {
            this.m_leftMotor.set(0.5);
            this.m_rightMotor.set(-0.7);
        } else if (dir == 1) {
            this.m_leftMotor.set(-0.5);
            this.m_rightMotor.set(0.7);
        }
    }

    public void turn(int dir) {
        if (dir == -1) {
            this.m_leftMotor.set(-0.5);
            this.m_rightMotor.set(-0.7);
        } else if (dir == 1) {
            this.m_leftMotor.set(0.5);
            this.m_rightMotor.set(0.7);
        }
    }

    public void stop() {
        this.m_leftMotor.set(0.0);
        this.m_rightMotor.set(0.0);
    }

    public void toggleFront() {
        if (RobotMap.normalFront) {
            RobotMap.normalFront = false;
            RobotMap.frontToggled = true;
        } else if (!RobotMap.normalFront) {
            RobotMap.normalFront = true;
            RobotMap.frontToggled = true;
        }
    }

    public void setMotors(Joystick stick) {
        double leftMotorSpeed = 0.0;
        double rightMotorSpeed = 0.0;
        if (RobotMap.normalFront) {
            leftMotorSpeed = -(-stick.getAxis(Joystick.AxisType.kY) + stick.getAxis(Joystick.AxisType.kX) + stick.getAxis(Joystick.AxisType.kZ));
            rightMotorSpeed = -stick.getAxis(Joystick.AxisType.kY) - stick.getAxis(Joystick.AxisType.kX) - stick.getAxis(Joystick.AxisType.kZ);
        } else if (!RobotMap.normalFront) {
            leftMotorSpeed = -stick.getAxis(Joystick.AxisType.kY) + stick.getAxis(Joystick.AxisType.kX) + stick.getAxis(Joystick.AxisType.kZ);
            rightMotorSpeed = -(-stick.getAxis(Joystick.AxisType.kY) - stick.getAxis(Joystick.AxisType.kX) - stick.getAxis(Joystick.AxisType.kZ));
        }
        this.m_leftMotor.set(leftMotorSpeed);
        this.m_rightMotor.set(rightMotorSpeed);
    }

    public void shift() {
        this.shifted = false;
        if (!this.m_shifter1.get()) {
            this.m_shifter1.set(true);
            this.m_shifter2.set(false);
            this.shifted = true;
        } else if (this.m_shifter1.get()) {
            this.m_shifter1.set(false);
            this.m_shifter2.set(true);
            this.shifted = true;
        }
    }

    public boolean getShifters() {
        return this.m_shifter1.get();
    }

    public boolean shifted() {
        return this.shifted;
    }

    public int getLeftCount() {
        return this.m_leftEncoder.get();
    }

    public int getRightCount() {
        return this.m_rightEncoder.get();
    }
}

