/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.templates.subsystems;

import edu.wpi.first.wpilibj.DigitalInput;
import edu.wpi.first.wpilibj.Relay;
import edu.wpi.first.wpilibj.command.Subsystem;
import edu.wpi.first.wpilibj.templates.RobotMap;
import edu.wpi.first.wpilibj.templates.commands.highlevel.H_BallHandle;

public class Elevator
extends Subsystem {
    protected Relay m_elevatorMotor = new Relay(2);
    protected DigitalInput m_elevatorSensor = new DigitalInput(10);
    protected DigitalInput m_ballSensor = new DigitalInput(11);
    private boolean currentValue = false;
    private boolean previousValue = false;
    private boolean currentAddValue = false;
    private boolean previousAddValue = false;
    private int m_ballCount;
    private long end = 1000L;
    private long start = 0L;
    private float time = 0.0f;

    public boolean timerDone() {
        long current = System.currentTimeMillis();
        return (float)(current - this.start) >= this.time;
    }

    public void startTimer(float timerLength) {
        if (this.timerDone()) {
            this.start = System.currentTimeMillis();
        }
        this.time = timerLength;
    }

    public void initDefaultCommand() {
        this.setDefaultCommand(new H_BallHandle());
    }

    public void up() {
        this.m_elevatorMotor.set(Relay.Value.kReverse);
    }

    public void up(float time) {
        this.m_elevatorMotor.set(Relay.Value.kReverse);
        this.startTimer(time);
    }

    public void stop() {
        this.m_elevatorMotor.set(Relay.Value.kOff);
    }

    public void down() {
        this.m_elevatorMotor.set(Relay.Value.kForward);
    }

    public boolean getBottomSensor() {
        return !this.m_elevatorSensor.get();
    }

    public boolean getTopSensor() {
        return !this.m_ballSensor.get();
    }

    public void setPreviousValue(boolean value) {
        this.previousValue = value;
    }

    public void setPreviousAddValue(boolean value) {
        this.previousAddValue = value;
    }

    public boolean ballAdded() {
        boolean bl = this.currentAddValue = !this.m_elevatorSensor.get();
        if (this.currentAddValue != this.previousAddValue && this.currentValue) {
            return true;
        }
        if (this.currentAddValue != this.previousAddValue) {
            this.previousAddValue = false;
        }
        return false;
    }

    public boolean ballRemoved() {
        if (RobotMap.isTeleop) {
            boolean bl = this.currentValue = !this.m_ballSensor.get();
            if (this.currentValue != this.previousValue && this.currentValue) {
                return true;
            }
            if (this.currentValue != this.previousValue) {
                this.previousValue = false;
            }
        } else if (RobotMap.isAutonomous) {
            RobotMap.currentTime = System.currentTimeMillis();
            if (RobotMap.currentTime - RobotMap.startTime >= this.end) {
                System.out.println("DONE");
                return true;
            }
            return false;
        }
        return false;
    }

    public void decrementBallCount() {
        --RobotMap.numBalls;
    }
}

