/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package edu.wpi.first.wpilibj.templates.commands.highlevel;

import edu.wpi.first.wpilibj.command.Command;
import edu.wpi.first.wpilibj.templates.RobotMap;
import edu.wpi.first.wpilibj.templates.commands.CommandBase;;

/**
 *
 * @author team1987
 */
public class H_BallHandle extends CommandBase {
    
    public H_BallHandle() {
        // Use requires() here to declare subsystem dependencies
        // eg. requires(chassis);
        requires(ballIntake);
        requires(elevator);
    }

    // Called just before this Command runs the first time
    protected void initialize() {
        ballIntake.intake();
    }

    // Called repeatedly when this Command is scheduled to run
    protected void execute() {
        if (oi.getJoystick2().getRawButton(1)){
            elevator.up();
        }
        else if (ballIntake.getBallSensor() && !elevator.getTopSensor() && elevator.timerDone()){
            elevator.up(700);
            System.out.println("Elevator:true Top:false");
        }
        else if (elevator.getTopSensor() && !elevator.getBottomSensor() && elevator.timerDone()){
            elevator.down();
            System.out.println("Top:true Elevator:false");
        }
        else if (elevator.getBottomSensor() && elevator.timerDone()){
            elevator.stop();
            System.out.println("Elevator:true");
        }
        else if (!ballIntake.getBallSensor() && !elevator.getBottomSensor() && !elevator.getTopSensor() && elevator.timerDone()){
            System.out.println("All:false - do nothing");
        }
        else if (elevator.timerDone()) {
            elevator.stop();
            System.out.println("SELF DESTRUCT SEQUENCE INITIATED (H_BallHandle)");
        }
        
    }

    // Make this return true when this Command no longer needs to run execute()
    protected boolean isFinished() {
        return false;
    }

    // Called once after isFinished returns true
    protected void end() {
    }

    // Called when another command which requires one or more of the same
    // subsystems is scheduled to run
    protected void interrupted() {
    }
}
