#include "RunCompressor.h"

RunCompressor::RunCompressor() 
{
	Requires(compressor);
}

// Called just before this Command runs the first time
void RunCompressor::Initialize()
{
	compressor->Start();
}

// Called repeatedly when this Command is scheduled to run
void RunCompressor::Execute() 
{
	if(compressor->GetPressureSwitchValue() == 0)
		{
			compressor->Start();
		}
	else
		{
			compressor->Stop();
		}
}

// Make this return true when this Command no longer needs to run execute()
bool RunCompressor::IsFinished() 
{
	//Compressor should never stop running.
	return false;
}

// Called once after isFinished returns true
void RunCompressor::End()
{
	
}

// Called when another command which requires one or more of the same
// subsystems is scheduled to run
void RunCompressor::Interrupted() 
{
	
}
